/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.state;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.portal.portlet.state.AccessMode;
import org.jboss.portal.portlet.state.PropertyChange;
import org.jboss.portal.portlet.state.PropertyContext;
import org.jboss.portal.portlet.state.PropertyMap;
import org.jboss.portal.portlet.state.SimplePropertyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPropertyContext
implements PropertyContext {
    public static final int NO_CHANGE = 0;
    public static final int UPDATE_FAILED = 1;
    public static final int UPDATE_SUCCESSFUL = 2;
    private final boolean render;
    private PropertyMap prefs;
    private final AccessMode access;
    private int status;

    public AbstractPropertyContext(AccessMode access, PropertyMap prefs, boolean render) throws IllegalArgumentException {
        if (access == null) {
            throw new IllegalArgumentException("No access mode provided");
        }
        this.access = access;
        this.prefs = prefs;
        this.status = 0;
        this.render = render;
    }

    @Override
    public void update(PropertyChange[] changes) throws IllegalStateException {
        if (this.access == AccessMode.READ_ONLY) {
            this.status = 1;
            throw new IllegalStateException("Cannot update when read only");
        }
        if (changes.length > 0) {
            if (this.status == 0) {
                this.prefs = this.prefs == null ? new SimplePropertyMap() : new SimplePropertyMap(this.prefs);
            }
            for (PropertyChange change : changes) {
                this.prefs.setProperty(change.getKey(), change.getValue());
            }
            this.status = 2;
        }
    }

    @Override
    public Set<String> getKeys() {
        if (this.prefs == null) {
            return Collections.emptySet();
        }
        return this.prefs.keySet();
    }

    @Override
    public List<String> getValue(String key) throws IllegalArgumentException {
        if (this.prefs == null) {
            return null;
        }
        return this.prefs.getProperty(key);
    }

    @Override
    public boolean isReadOnly() {
        if (this.render) {
            throw new IllegalStateException("Not authorized to call this method during the render phase");
        }
        return this.access == AccessMode.READ_ONLY;
    }

    public PropertyMap getPrefs() {
        return this.prefs;
    }

    public int getStatus() {
        return this.status;
    }
}

