/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.ring;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.SuspectedException;
import org.jgroups.TimeoutException;
import org.jgroups.protocols.ring.RingNode;
import org.jgroups.protocols.ring.RingToken;
import org.jgroups.protocols.ring.TokenLostException;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.RpcProtocol;
import org.jgroups.util.Util;

public class TcpRingNode
implements RingNode {
    final ServerSocket tokenReceiver;
    Socket previous;
    Socket next;
    final Address thisNode;
    Address nextNode;
    ObjectInputStream ios;
    ObjectOutputStream oos;
    final RpcProtocol rpcProtocol;
    final boolean failedOnTokenLostException = false;
    final Object socketMutex = new Object();
    protected final Log log = LogFactory.getLog(this.getClass());

    public TcpRingNode(RpcProtocol owner, Address memberAddress) {
        this.tokenReceiver = Util.createServerSocket(12000);
        this.rpcProtocol = owner;
        this.thisNode = memberAddress;
        this.nextNode = null;
    }

    public IpAddress getTokenReceiverAddress() {
        return new IpAddress(this.tokenReceiver.getLocalPort());
    }

    public Object receiveToken(int timeout) throws TokenLostException {
        RingToken token = null;
        Address wasNextNode = this.nextNode;
        try {
            if (this.previous == null) {
                this.previous = this.tokenReceiver.accept();
                this.ios = new ObjectInputStream(this.previous.getInputStream());
            }
            this.previous.setSoTimeout(timeout);
            token = new RingToken();
            token.readExternal(this.ios);
        }
        catch (InterruptedIOException io) {
            throw new TokenLostException(io.getMessage(), (Throwable)io, wasNextNode, 1);
        }
        catch (ClassNotFoundException cantHappen) {
        }
        catch (IOException ioe) {
            this.closeSocket(this.previous);
            this.previous = null;
            if (this.ios != null) {
                try {
                    this.ios.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            token = (RingToken)this.receiveToken(timeout);
        }
        return token;
    }

    public Object receiveToken() throws TokenLostException {
        return this.receiveToken(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passToken(Object token) throws TokenLostException {
        Object object = this.socketMutex;
        synchronized (object) {
            try {
                ((Externalizable)token).writeExternal(this.oos);
                this.oos.flush();
                this.oos.reset();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new TokenLostException(e.getMessage(), (Throwable)e, this.nextNode, 2);
            }
        }
    }

    public void tokenArrived(Object token) {
    }

    public void reconfigureAll(Vector newMembers) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(Vector newMembers) {
        if (this.isNextNeighbourChanged(newMembers)) {
            IpAddress tokenRecieverAddress = null;
            Object object = this.socketMutex;
            synchronized (object) {
                this.nextNode = this.getNextNode(newMembers);
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)(" next node " + this.nextNode));
                }
                try {
                    tokenRecieverAddress = (IpAddress)this.rpcProtocol.callRemoteMethod(this.nextNode, "getTokenReceiverAddress", 1, 0L);
                }
                catch (TimeoutException tim) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)(" timeouted while doing rpc call getTokenReceiverAddress" + tim));
                    }
                    tim.printStackTrace();
                }
                catch (SuspectedException sus) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)(" suspected node while doing rpc call getTokenReceiverAddress" + sus));
                    }
                    sus.printStackTrace();
                }
                try {
                    this.closeSocket(this.next);
                    this.next = new Socket(tokenRecieverAddress.getIpAddress(), tokenRecieverAddress.getPort());
                    this.next.setTcpNoDelay(true);
                    this.oos = new ObjectOutputStream(this.next.getOutputStream());
                }
                catch (IOException ioe) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("could not connect to next node " + ioe));
                    }
                    ioe.printStackTrace();
                }
            }
        }
    }

    private void closeSocket(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private boolean isNextNeighbourChanged(Vector newMembers) {
        Address oldNeighbour = this.nextNode;
        Address newNeighbour = this.getNextNode(newMembers);
        return !newNeighbour.equals(oldNeighbour);
    }

    private Address getNextNode(Vector otherNodes) {
        int myIndex = otherNodes.indexOf(this.thisNode);
        return myIndex == otherNodes.size() - 1 ? (Address)otherNodes.firstElement() : (Address)otherNodes.elementAt(myIndex + 1);
    }
}

