/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.management.MBeanServer;
import org.jgroups.Channel;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class LargeState
extends ExtendedReceiverAdapter {
    Channel channel;
    byte[] state = null;
    Thread getter = null;
    boolean rc = false;
    String props;
    long start;
    long stop;
    boolean provider = true;
    int size = 100000;
    int total_received = 0;
    final Promise state_promise = new Promise();
    final int STREAMING_CHUNK_SIZE = 10000;

    public void start(boolean provider, int size, String props, boolean jmx) throws Exception {
        this.provider = provider;
        this.channel = new JChannel(props);
        this.channel.setReceiver(this);
        this.channel.connect("TestChannel");
        if (jmx) {
            MBeanServer server = Util.getMBeanServer();
            if (server == null) {
                throw new Exception("No MBeanServers found;\nLargeState needs to be run with an MBeanServer present, or inside JDK 5");
            }
            JmxConfigurator.registerChannel((JChannel)this.channel, server, "jgroups", this.channel.getClusterName(), true);
        }
        System.out.println("-- connected to channel");
        if (provider) {
            this.size = size;
            System.out.println("Waiting for other members to join and fetch large state");
        } else {
            System.out.println("Getting state");
            this.start = System.currentTimeMillis();
            this.state_promise.reset();
            this.rc = this.channel.getState(null, 0L);
            System.out.println("getState(), rc=" + this.rc);
            if (this.rc) {
                this.state_promise.getResult(10000L);
            }
        }
        if (provider) {
            while (true) {
                Util.sleep(10000L);
            }
        }
        this.channel.close();
    }

    byte[] createLargeState(int size) {
        return new byte[size];
    }

    public void receive(Message msg) {
        System.out.println("-- received msg " + msg.getObject() + " from " + msg.getSrc());
    }

    public void viewAccepted(View new_view) {
        if (this.provider) {
            System.out.println("-- view: " + new_view);
        }
    }

    public byte[] getState() {
        if (this.state == null) {
            System.out.println("creating state of " + this.size + " bytes");
            this.state = this.createLargeState(this.size);
        }
        System.out.println("--> returning state: " + this.state.length + " bytes");
        return this.state;
    }

    public void setState(byte[] state) {
        this.stop = System.currentTimeMillis();
        if (state != null) {
            this.state = state;
            System.out.println("<-- Received state, size =" + state.length + " (took " + (this.stop - this.start) + "ms)");
        }
        this.state_promise.setResult(Boolean.TRUE);
    }

    public byte[] getState(String state_id) {
        if (state_id == null) {
            return this.getState();
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void setState(String state_id, byte[] state) {
        if (state_id == null) {
            this.setState(state);
            this.state_promise.setResult(Boolean.TRUE);
            return;
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void getState(String state_id, OutputStream ostream) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(InputStream istream) {
        try {
            this.total_received = 0;
            int received = 0;
            while (true) {
                byte[] buf = new byte[10000];
                try {
                    received = istream.read(buf);
                    if (received < 0) break;
                    this.total_received += received;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            this.stop = System.currentTimeMillis();
            System.out.println("<-- Received state, size=" + this.total_received + " (took " + (this.stop - this.start) + "ms)");
            this.state_promise.setResult(Boolean.TRUE);
        }
        finally {
            Util.close(istream);
        }
    }

    public void setState(String state_id, InputStream istream) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getState(OutputStream ostream) {
        try {
            int remaining;
            byte[] buf;
            int frag_size = this.size / 10;
            for (int i = 0; i < 10; ++i) {
                buf = new byte[frag_size];
                try {
                    ostream.write(buf);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            if ((remaining = this.size - 10 * frag_size) > 0) {
                buf = new byte[remaining];
                try {
                    ostream.write(buf);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            Util.close(ostream);
        }
    }

    public static void main(String[] args) {
        boolean provider = false;
        boolean jmx = false;
        int size = 0x100000;
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                LargeState.help();
                return;
            }
            if ("-provider".equals(args[i])) {
                provider = true;
                continue;
            }
            if ("-jmx".equals(args[i])) {
                jmx = true;
                continue;
            }
            if ("-size".equals(args[i])) {
                size = Integer.parseInt(args[++i]);
                continue;
            }
            if (!"-props".equals(args[i])) continue;
            props = args[++i];
        }
        try {
            new LargeState().start(provider, size, props, jmx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void help() {
        System.out.println("LargeState [-help] [-size <size of state in bytes] [-provider] [-props <properties>] [-jmx]");
    }
}

