/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.deployment.jboss;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.management.MBeanServer;
import javax.servlet.ServletContext;
import org.jboss.deployment.DeploymentException;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.xml.NullEntityResolver;
import org.jboss.portal.portlet.container.PortletApplicationContext;
import org.jboss.portal.portlet.container.PortletContainerContext;
import org.jboss.portal.portlet.container.PortletFilterContext;
import org.jboss.portal.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.jboss.portal.portlet.container.object.PortletApplicationObject;
import org.jboss.portal.portlet.container.object.PortletContainerObject;
import org.jboss.portal.portlet.container.object.PortletFilterObject;
import org.jboss.portal.portlet.deployment.PortletApplicationModelFactory;
import org.jboss.portal.portlet.deployment.jboss.InfoBuilder;
import org.jboss.portal.portlet.deployment.jboss.JBossApplicationMetaDataFactory;
import org.jboss.portal.portlet.deployment.jboss.PortletAppDeploymentFactory;
import org.jboss.portal.portlet.deployment.jboss.PortletApplicationContextImpl;
import org.jboss.portal.portlet.deployment.jboss.PortletContainerContextImpl;
import org.jboss.portal.portlet.deployment.jboss.PortletFilterContextImpl;
import org.jboss.portal.portlet.deployment.jboss.ValueTrimmingFilter;
import org.jboss.portal.portlet.deployment.jboss.metadata.JBossApplicationMetaData;
import org.jboss.portal.portlet.deployment.jboss.metadata.JBossPortletMetaData;
import org.jboss.portal.portlet.impl.container.PortletApplicationLifeCycle;
import org.jboss.portal.portlet.impl.container.PortletContainerLifeCycle;
import org.jboss.portal.portlet.impl.container.PortletFilterLifeCycle;
import org.jboss.portal.portlet.impl.info.ContainerFilterInfo;
import org.jboss.portal.portlet.impl.info.ContainerPortletInfo;
import org.jboss.portal.portlet.impl.jsr168.PortletApplicationImpl;
import org.jboss.portal.portlet.impl.jsr168.PortletContainerImpl;
import org.jboss.portal.portlet.impl.jsr168.PortletFilterImpl;
import org.jboss.portal.portlet.impl.metadata.PortletApplication10MetaData;
import org.jboss.portal.portlet.impl.metadata.PortletApplication20MetaData;
import org.jboss.portal.portlet.impl.metadata.portlet.PortletMetaData;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.jboss.portal.server.deployment.jboss.Deployment;
import org.jboss.portal.web.WebApp;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.xml.sax.EntityResolver;

public class PortletAppDeployment
extends Deployment {
    protected Map configurations;
    protected PortletApplication10MetaData portletAppMD;
    protected JBossApplicationMetaData jbossAppMD;
    protected PortletAppDeploymentFactory factory;
    protected PortletApplicationContextImpl portletApplicationContext;
    private PortletApplicationLifeCycle portletApplicationLifeCycle;
    private ManagedObjectRegistryEventListener listener;
    private String appId;

    public PortletAppDeployment(URL url, PortalWebApp pwa, ManagedObjectRegistryEventListener listener, MBeanServer mbeanServer, PortletAppDeploymentFactory factory) {
        super(url, pwa, mbeanServer);
        this.factory = factory;
        this.listener = listener;
    }

    public void create() throws DeploymentException {
        try {
            this.portletAppMD = this.buildPortletApplicationMetaData();
            this.jbossAppMD = this.buildJBossApplicationMetaData();
            this.importTLD();
            if (this.jbossAppMD.getId() == null) {
                this.log.debug((Object)"The portlet application does not have an explicit id value, will use the value provided by the jboss-app.xml instead");
                this.jbossAppMD.setId(this.pwa.getId());
            }
            this.appId = this.jbossAppMD.getId();
            JBossApplicationMetaData standardJBossAppMD = this.factory.getStandardJBossApplicationMetaData();
            if (standardJBossAppMD != null) {
                this.log.debug((Object)"Found standard jboss app meta data");
                JBossPortletMetaData defaultJBossPortletMD = standardJBossAppMD.getPortlets().get("DefaultPortlet");
                if (defaultJBossPortletMD != null) {
                    this.log.debug((Object)"Found default jboss portlet meta data");
                    for (PortletMetaData portletMD : this.portletAppMD.getPortlets().values()) {
                        String name = portletMD.getPortletName();
                        JBossPortletMetaData jbossPortletMD = this.jbossAppMD.getPortlets().get(name);
                        if (jbossPortletMD != null) {
                            this.log.debug((Object)("Merging default jboss portlet meta data for " + name));
                            jbossPortletMD.merge(defaultJBossPortletMD);
                            continue;
                        }
                        this.log.debug((Object)("Using default jboss portlet meta data for " + name));
                        this.jbossAppMD.getPortlets().put(name, (JBossPortletMetaData)defaultJBossPortletMD.clone());
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new DeploymentException("Cannot deploy portlet application", e);
        }
    }

    public void start() throws DeploymentException {
        this.log.debug((Object)"Starting installation");
        InfoBuilder infoBuilder = this.factory.getCoreInfoBuilderFactory().createInfoBuilder(this.pwa, this.jbossAppMD, this.portletAppMD);
        infoBuilder.build();
        PortletApplicationImpl portletApplicationObject = new PortletApplicationImpl(infoBuilder.getApplication());
        PortletApplicationContextImpl portletApplicationContext = new PortletApplicationContextImpl((WebApp)this.pwa);
        this.portletApplicationLifeCycle = new PortletApplicationLifeCycle(this.listener, (PortletApplicationContext)portletApplicationContext, (PortletApplicationObject)portletApplicationObject);
        for (ContainerFilterInfo filterInfo : infoBuilder.getApplication().getFilters().values()) {
            PortletFilterImpl portletFilterObject = new PortletFilterImpl(filterInfo);
            PortletFilterContextImpl portletFilterContext = new PortletFilterContextImpl();
            this.portletApplicationLifeCycle.addPortletFilter((PortletFilterContext)portletFilterContext, (PortletFilterObject)portletFilterObject);
        }
        for (PortletInfo portletInfo : infoBuilder.getPortlets()) {
            ContainerPortletInfo cpi = (ContainerPortletInfo)portletInfo;
            PortletContainerImpl portletContainerObject = new PortletContainerImpl(cpi);
            PortletContainerContextImpl portletContainerContext = new PortletContainerContextImpl();
            PortletContainerLifeCycle portletContainerLifeCycle = this.portletApplicationLifeCycle.addPortletContainer((PortletContainerContext)portletContainerContext, (PortletContainerObject)portletContainerObject);
            for (String filterRef : cpi.getFilterRefs()) {
                PortletFilterLifeCycle portletFilterLifeCycle = this.portletApplicationLifeCycle.getManagedPortletFilter(filterRef);
                if (portletFilterLifeCycle == null) continue;
                this.portletApplicationLifeCycle.addDependency(portletFilterLifeCycle, portletContainerLifeCycle);
            }
        }
        this.portletApplicationLifeCycle.create();
        this.portletApplicationLifeCycle.managedStart();
        super.start();
    }

    public void stop() throws DeploymentException {
        super.stop();
    }

    public void destroy() throws DeploymentException {
        this.portletApplicationLifeCycle.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importTLD() {
        BufferedInputStream sourceTLD = null;
        try {
            String tldName;
            if (this.portletAppMD instanceof PortletApplication20MetaData) {
                sourceTLD = IOTools.safeBufferedWrapper((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/portlet_2_0.tld"));
                tldName = "portlet_2_0.tld";
            } else {
                sourceTLD = IOTools.safeBufferedWrapper((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/portlet.tld"));
                tldName = "portlet.tld";
            }
            this.pwa.importFile("/WEB-INF", tldName, (InputStream)sourceTLD, false);
        }
        catch (IOException e) {
            try {
                this.log.warn((Object)"Cannot copy TLD file to the portlet application", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOTools.safeClose(sourceTLD);
                throw throwable;
            }
            IOTools.safeClose((Closeable)sourceTLD);
        }
        IOTools.safeClose((Closeable)sourceTLD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortletApplication10MetaData buildPortletApplicationMetaData() throws Exception {
        PortletApplication10MetaData portletApplication10MetaData;
        BufferedInputStream in = null;
        try {
            in = IOTools.safeBufferedWrapper((InputStream)this.url.openStream());
            PortletApplicationModelFactory factory = new PortletApplicationModelFactory();
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            PortletApplication10MetaData portletAppMD = (PortletApplication10MetaData)unmarshaller.unmarshal((InputStream)in, (ObjectModelFactory)new ValueTrimmingFilter(factory), null);
            portletAppMD.setId(this.pwa.getId());
            portletApplication10MetaData = portletAppMD;
        }
        catch (Throwable throwable) {
            IOTools.safeClose(in);
            throw throwable;
        }
        IOTools.safeClose((Closeable)in);
        return portletApplication10MetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JBossApplicationMetaData buildJBossApplicationMetaData() {
        BufferedInputStream in;
        JBossApplicationMetaData jbossAppMD;
        block6: {
            jbossAppMD = new JBossApplicationMetaData();
            ServletContext servletContext = this.pwa.getServletContext();
            String contextPath = this.pwa.getContextPath();
            in = null;
            try {
                in = IOTools.safeBufferedWrapper((InputStream)servletContext.getResourceAsStream("/WEB-INF/jboss-portlet.xml"));
                if (in == null) break block6;
                this.log.info((Object)("Parsing " + contextPath + "/jboss-portlet.xml"));
                JBossApplicationMetaDataFactory factory = this.factory.createJBossApplicationMetaDataFactory();
                Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                EntityResolver entityResolver = this.factory.getJBossPortletEntityResolver();
                if (entityResolver == null) {
                    this.log.debug((Object)"Could not obtain entity resolver for jboss-portlet.xml");
                    entityResolver = new NullEntityResolver();
                } else {
                    this.log.debug((Object)("Obtained entity resolver " + entityResolver + " for jboss-portlet.xml"));
                }
                unmarshaller.setEntityResolver(entityResolver);
                jbossAppMD = (JBossApplicationMetaData)unmarshaller.unmarshal((InputStream)in, (ObjectModelFactory)new ValueTrimmingFilter(factory), null);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOTools.safeClose(in);
                    throw throwable;
                }
                IOTools.safeClose((Closeable)in);
            }
        }
        IOTools.safeClose((Closeable)in);
        return jbossAppMD;
    }

    public String getAppId() {
        return this.appId;
    }
}

