/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.jems.hibernate;

import bsh.EvalError;
import bsh.Interpreter;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Collection;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.net.URLTools;
import org.jboss.portal.common.util.CLResourceLoader;
import org.jboss.portal.common.util.LoaderResource;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.jems.hibernate.DialectFactory;
import org.jboss.portal.jems.hibernate.HibernateProvider;

public class SessionFactoryBinder
extends AbstractJBossService
implements HibernateProvider {
    private static final int RESULT_NONE = 0;
    private static final int RESULT_UPDATE = 1;
    private static final int RESULT_CREATE = 2;
    private String configLocation;
    private String setupLocation;
    private boolean doChecking;
    private SessionFactory sessionFactory;
    private URL configURL;
    private LoaderResource setupResource;
    protected Configuration config;
    private String dialectName;
    protected String jndiName;

    public boolean getDoChecking() {
        return this.doChecking;
    }

    public void setDoChecking(boolean doChecking) {
        this.doChecking = doChecking;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public String getSetupLocation() {
        return this.setupLocation;
    }

    public void setSetupLocation(String setupLocation) {
        this.setupLocation = setupLocation;
    }

    public URL getConfigURL() {
        return this.configURL;
    }

    public LoaderResource getSetupResource() {
        return this.setupResource;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public String getDialectName() {
        return this.dialectName;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    protected void createService() throws Exception {
        if (this.configLocation == null) {
            throw new Exception("The config location is null");
        }
        this.configURL = Thread.currentThread().getContextClassLoader().getResource(this.configLocation);
        if (this.configURL == null) {
            throw new Exception("The config " + this.configLocation + " does not exist");
        }
        if (!URLTools.exists((URL)this.configURL)) {
            throw new Exception("The config " + this.configURL + " does not exist");
        }
        if (this.setupLocation != null) {
            this.setupResource = new CLResourceLoader().getResource(this.setupLocation);
        }
        this.config = new Configuration();
        this.config.configure(this.configURL);
        this.setPropertyIfAbsent("transaction.auto_close_session", "true");
        this.setPropertyIfAbsent("transaction.flush_before_completion", "true");
        this.setPropertyIfAbsent("hibernate.transaction.flush_before_completion", "true");
        this.setPropertyIfAbsent("hibernate.transaction.factory_class", "org.hibernate.transaction.JTATransactionFactory");
        this.setPropertyIfAbsent("hibernate.transaction.manager_lookup_class", "org.hibernate.transaction.JBossTransactionManagerLookup");
        if (this.jndiName != null) {
            this.setPropertyIfAbsent("hibernate.session_factory_name", this.jndiName);
        }
    }

    private void setPropertyIfAbsent(String name, String value) {
        if (this.config.getProperty(name) == null) {
            this.config.setProperty(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        this.dialectName = this.config.getProperty("hibernate.dialect");
        if (this.dialectName == null) {
            String dataSourceJNDI = this.config.getProperty("hibernate.connection.datasource");
            this.log.debug((Object)("Detecting dialect with datasource " + dataSourceJNDI + " ..."));
            DataSource ds = (DataSource)new InitialContext().lookup(dataSourceJNDI);
            Connection conn = null;
            try {
                conn = ds.getConnection();
                DatabaseMetaData meta = conn.getMetaData();
                String databaseName = meta.getDatabaseProductName();
                int databaseMajorVersion = this.getDatabaseMajorVersion(meta);
                this.dialectName = DialectFactory.determineDialect(databaseName, databaseMajorVersion);
                this.config.setProperty("hibernate.dialect", this.dialectName);
                this.log.debug((Object)("Detected dialect " + this.dialectName + ", database is (" + databaseName + "," + databaseMajorVersion + ")"));
            }
            finally {
                IOTools.safeClose((Object)conn);
            }
        }
        this.log.debug((Object)("Using dialect " + this.dialectName));
        if ("org.hibernate.dialect.HSQLDialect".equals(this.dialectName)) {
            this.log.warn((Object)"You are using the file based HSQL database, this is not recommended on a production environment and will not work properly on a clustered environment.");
        }
        this.createSessionFactory();
        if (this.doChecking) {
            int check = this.doCheck();
            switch (check) {
                case 0: {
                    break;
                }
                case 1: {
                    this.updateSchema();
                    break;
                }
                case 2: {
                    this.createSchema();
                    this.createContent();
                }
            }
        }
    }

    protected void stopService() throws Exception {
        this.destroySessionFactory();
    }

    protected void destroyService() throws Exception {
        this.config = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doCheck() {
        Session session = null;
        int numOfChecks = 0;
        int bad = 0;
        try {
            session = this.sessionFactory.openSession();
            Collection values = this.sessionFactory.getAllClassMetadata().values();
            numOfChecks = values.size();
            for (ClassMetadata cmd : values) {
                Query query = session.createQuery("from " + cmd.getEntityName());
                query.setFirstResult(0);
                query.setMaxResults(0);
                try {
                    query.list();
                }
                catch (SQLGrammarException e) {
                    ++bad;
                }
            }
        }
        finally {
            IOTools.safeClose((Object)session);
        }
        if (bad == 0) {
            this.log.debug((Object)"The schema was checked as valid");
            return 0;
        }
        if (bad == numOfChecks) {
            this.log.debug((Object)"The schema was checked as not exists");
            return 2;
        }
        if (bad < numOfChecks) {
            this.log.debug((Object)"The schema was checked as need updates");
            return 1;
        }
        this.log.debug((Object)"The schema was checked as need to be created");
        return 2;
    }

    public void createSchema() {
        this.log.debug((Object)"Creating database schema");
        try {
            SchemaExport export = new SchemaExport(this.config);
            export.create(false, true);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot create schema", (Throwable)e);
        }
    }

    public void destroySchema() {
        this.log.debug((Object)"Destroying database schema");
        try {
            SchemaExport export = new SchemaExport(this.config);
            export.drop(false, true);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot destroy schema", (Throwable)e);
        }
    }

    public void createContent() {
        if (this.setupResource != null) {
            if (this.setupResource.exists()) {
                try {
                    this.log.info((Object)"Creating database content");
                    String script = this.setupResource.asString("UTF-8");
                    Interpreter interpreter = new Interpreter();
                    interpreter.setClassLoader(Thread.currentThread().getContextClassLoader());
                    interpreter.setOut(System.out);
                    interpreter.set("SessionFactory", (Object)this.sessionFactory);
                    interpreter.eval(script);
                }
                catch (EvalError e) {
                    this.log.error((Object)"Error in the bsh script", (Throwable)e);
                }
                catch (IllegalStateException e) {
                    this.log.error((Object)"Cannot load setup script", (Throwable)e);
                }
            } else {
                this.log.warn((Object)("There is a setup URL but the not valid " + this.setupResource));
            }
        }
    }

    public void updateSchema() {
        this.log.debug((Object)"Updating database schema");
        SchemaUpdate update = new SchemaUpdate(this.config);
        update.execute(false, true);
    }

    protected void createSessionFactory() throws Exception {
        this.sessionFactory = this.config.buildSessionFactory();
    }

    protected void destroySessionFactory() {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        } else {
            this.log.debug((Object)"No session factory to close");
        }
    }

    private int getDatabaseMajorVersion(DatabaseMetaData meta) {
        try {
            Method gdbmvMethod = DatabaseMetaData.class.getMethod("getDatabaseMajorVersion", null);
            return (Integer)gdbmvMethod.invoke((Object)meta, null);
        }
        catch (NoSuchMethodException nsme) {
            return 0;
        }
        catch (Throwable t) {
            this.log.debug((Object)"could not get database version from JDBC metadata");
            return 0;
        }
    }
}

