/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.marshall.LegacyTreeCacheMarshaller;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.ObjectSerializationFactory;
import org.jboss.cache.marshall.RegionManager;
import org.jboss.cache.marshall.RegionNameConflictException;
import org.jboss.cache.marshall.RegionNotFoundException;
import org.jboss.cache.marshall.TreeCacheMarshaller140;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.invocation.MarshalledValueOutputStream;
import org.jgroups.blocks.RpcDispatcher;

public class VersionAwareMarshaller
implements RpcDispatcher.Marshaller {
    private RegionManager manager;
    private boolean defaultInactive;
    private boolean useRegionBasedMarshalling;
    private Log log = LogFactory.getLog((Class)VersionAwareMarshaller.class);
    Marshaller defaultMarshaller;
    Map marshallers = new HashMap();
    private static final int VERSION_LEGACY = 1;
    private static final int VERSION_140 = 14;
    private static final int VERSION_200 = 20;
    private int versionInt;

    public VersionAwareMarshaller(RegionManager manager, boolean defaultInactive, boolean useRegionBasedMarshalling, String version) {
        this.manager = manager;
        this.defaultInactive = defaultInactive;
        this.useRegionBasedMarshalling = useRegionBasedMarshalling;
        this.versionInt = this.toMinorVersionInt(version);
        switch (this.versionInt) {
            case 14: 
            case 20: {
                this.defaultMarshaller = new TreeCacheMarshaller140(manager, defaultInactive, useRegionBasedMarshalling);
                this.marshallers.put(new Integer(14), this.defaultMarshaller);
                break;
            }
            default: {
                this.defaultMarshaller = new LegacyTreeCacheMarshaller(manager, defaultInactive, useRegionBasedMarshalling);
                this.marshallers.put(new Integer(1), this.defaultMarshaller);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initialised with version " + version + " and versionInt " + this.versionInt));
            this.log.debug((Object)("Using default marshaller " + this.defaultMarshaller.getClass()));
        }
    }

    private int toMinorVersionInt(String version) {
        try {
            StringTokenizer strtok = new StringTokenizer(version, ".");
            String[] versionComponents = new String[]{null, null, null, null};
            int i = 0;
            while (strtok.hasMoreTokens()) {
                versionComponents[i++] = strtok.nextToken();
            }
            int major = Integer.parseInt(versionComponents[0]);
            int minor = Integer.parseInt(versionComponents[1]);
            return major > 1 || minor > 3 ? 10 * major + minor : 1;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported replication version string " + version);
        }
    }

    public byte[] objectToByteBuffer(Object obj) throws Exception {
        ObjectOutputStream out;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (this.defaultMarshaller instanceof LegacyTreeCacheMarshaller) {
            out = new MarshalledValueOutputStream((OutputStream)bos);
        } else {
            out = ObjectSerializationFactory.createObjectOutputStream(bos);
            out.writeShort(this.versionInt);
        }
        this.defaultMarshaller.objectToStream(obj, out);
        out.close();
        return bos.toByteArray();
    }

    public Object objectFromByteBuffer(byte[] buf) throws Exception {
        short versionId = 1;
        ObjectInputStream in = null;
        try {
            in = ObjectSerializationFactory.createObjectInputStream(buf);
            versionId = in.readShort();
        }
        catch (Exception e) {
            this.log.debug((Object)"Unable to read version id from first two bytes of stream.  Probably from a version prior to JBC 1.4.0.  Reverting to using a LegacyTreeCacheMarshaller for this communication.");
        }
        Marshaller marshaller = this.getMarshaller(versionId);
        if (marshaller instanceof LegacyTreeCacheMarshaller) {
            in = new MarshalledValueInputStream((InputStream)new ByteArrayInputStream(buf));
        }
        try {
            return marshaller.objectFromStream(in);
        }
        catch (Exception e) {
            if (marshaller instanceof LegacyTreeCacheMarshaller) {
                throw e;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Caught exception unmarshalling stream with specific versioned marshaller " + marshaller.getClass() + ".  Attempting to try again with legacy marshaller " + LegacyTreeCacheMarshaller.class));
            }
            try {
                in = new MarshalledValueInputStream((InputStream)new ByteArrayInputStream(buf));
                return this.getMarshaller(1).objectFromStream(in);
            }
            catch (Exception e1) {
                this.log.debug((Object)"Retry with legacy marshaller failed as well; throwing original exception", (Throwable)e1);
                throw e;
            }
        }
    }

    Marshaller getMarshaller(int versionId) {
        Marshaller marshaller;
        switch (versionId) {
            case 14: {
                marshaller = (Marshaller)this.marshallers.get(new Integer(14));
                if (marshaller != null) break;
                marshaller = new TreeCacheMarshaller140(this.manager, this.defaultInactive, this.useRegionBasedMarshalling);
                this.marshallers.put(new Integer(14), marshaller);
                break;
            }
            default: {
                marshaller = (Marshaller)this.marshallers.get(new Integer(1));
                if (marshaller != null) break;
                marshaller = new LegacyTreeCacheMarshaller(this.manager, this.defaultInactive, this.useRegionBasedMarshalling);
                this.marshallers.put(new Integer(1), marshaller);
            }
        }
        return marshaller;
    }

    public void registerClassLoader(String fqn, ClassLoader cl) throws RegionNameConflictException {
        this.defaultMarshaller.registerClassLoader(fqn, cl);
    }

    public void unregisterClassLoader(String fqn) throws RegionNotFoundException {
        this.defaultMarshaller.unregisterClassLoader(fqn);
    }

    public boolean isInactive(String s) {
        return this.defaultMarshaller.isInactive(s);
    }

    public ClassLoader getClassLoader(String fqnS) throws RegionNotFoundException {
        return this.defaultMarshaller.getClassLoader(fqnS);
    }

    public void inactivate(String subtreeFqn) throws RegionNameConflictException {
        this.defaultMarshaller.inactivate(subtreeFqn);
    }

    public void activate(String subtreeFqn) throws RegionNameConflictException {
        this.defaultMarshaller.activate(subtreeFqn);
    }
}

