/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.search.impl.lucene;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.jboss.portal.search.IndexingException;
import org.jboss.portal.search.federation.Info;
import org.jboss.portal.search.impl.AbstractFederatedIndexer;
import org.jboss.portal.search.impl.lucene.GenericDocument;

public abstract class LuceneFederatedIndexer
extends AbstractFederatedIndexer {
    private IndexWriter index;
    private String indexPath;

    public LuceneFederatedIndexer(String id, String indexPath) {
        this.id = id;
        this.indexPath = indexPath;
    }

    public void createIndex() throws IndexingException {
        try {
            this.index = new IndexWriter(this.indexPath, (Analyzer)new StandardAnalyzer(), true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.info.setStatus(1);
        try {
            List documents = this.getLuceneDocuments();
            for (Document document : documents) {
                this.index.addDocument(document);
            }
            this.index.optimize();
            this.index.close();
        }
        catch (IOException e) {
            throw new IndexingException("Cannot index document", e);
        }
        this.info.setStatus(0);
    }

    public List getLuceneDocuments() {
        List documents = this.getDocuments();
        for (GenericDocument genericDoc : documents) {
            Document doc = new Document();
            if (genericDoc.getTitle() != null) {
                doc.add((Fieldable)new Field("title", genericDoc.getTitle(), Field.Store.YES, Field.Index.TOKENIZED));
            }
            if (genericDoc.getDate() != 0L) {
                doc.add((Fieldable)new Field("date", genericDoc.getDate() + "", Field.Store.YES, Field.Index.TOKENIZED));
            }
            if (genericDoc.getFields() != null) {
                Map map = genericDoc.getFields();
                for (String key : map.keySet()) {
                    doc.add((Fieldable)new Field(key, (String)map.get(key), Field.Store.YES, Field.Index.TOKENIZED));
                }
            }
            documents.add(doc);
        }
        return documents;
    }

    public abstract List getDocuments();

    public void destroyIndex() {
        this.info.setStatus(5);
    }

    public String getId() {
        return this.id;
    }

    public Info getInfo() {
        return this.info;
    }
}

