/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.deployment.jboss;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.management.MBeanServer;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.jboss.portal.server.deployment.jboss.Deployment;
import org.jboss.portal.theme.LayoutException;
import org.jboss.portal.theme.LayoutService;
import org.jboss.portal.theme.RuntimeContext;
import org.jboss.portal.theme.deployment.jboss.LayoutDeploymentFactory;
import org.jboss.portal.theme.deployment.jboss.PortalLayoutMetaDataFactory;
import org.jboss.portal.theme.metadata.PortalLayoutMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

public class LayoutDeployment
extends Deployment {
    private static Logger log = Logger.getLogger(LayoutDeployment.class);
    private final LayoutDeploymentFactory factory;

    public LayoutDeployment(URL url, PortalWebApp pwa, MBeanServer mbeanServer, LayoutDeploymentFactory layoutDeploymentFactory) {
        super(url, pwa, mbeanServer);
        this.factory = layoutDeploymentFactory;
    }

    public void create() throws DeploymentException {
        block11: {
            block10: {
                log.debug((Object)("Create new layout(s), found in :  " + this.pwa.getId()));
                BufferedInputStream in = null;
                try {
                    in = IOTools.safeBufferedWrapper((InputStream)this.url.openStream());
                    LayoutService layoutService = this.factory.getLayoutService();
                    RuntimeContext ctx = new RuntimeContext(this.pwa.getId(), this.pwa.getServletContext(), this.pwa.getContextPath(), this.pwa.getClassLoader());
                    Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                    List portalLayouts = (List)unmarshaller.unmarshal((InputStream)in, (ObjectModelFactory)new PortalLayoutMetaDataFactory(), null);
                    for (PortalLayoutMetaData layoutMD : portalLayouts) {
                        layoutService.addLayout(ctx, layoutMD);
                    }
                    log.debug((Object)("Done creating new layout(s), found in :  " + this.pwa.getId()));
                }
                catch (Exception e) {
                    try {
                        throw new DeploymentException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOTools.safeClose(in);
                        throw throwable;
                    }
                }
                IOTools.safeClose((Closeable)in);
                File targetContextRoot = new File(this.pwa.getServletContext().getRealPath("/WEB-INF"));
                if (!targetContextRoot.exists() || !targetContextRoot.isDirectory()) break block10;
                BufferedInputStream source = null;
                try {
                    source = IOTools.safeBufferedWrapper((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/theme/portal-layout.tld"));
                    this.pwa.importFile("/WEB-INF/theme", "portal-layout.tld", (InputStream)source, false);
                }
                catch (IOException e) {
                    try {
                        throw new DeploymentException("Cannot import portal-layout.tld", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOTools.safeClose(source);
                        throw throwable;
                    }
                }
                IOTools.safeClose((Closeable)source);
                break block11;
            }
            log.warn((Object)("Cannot access the WEB-INF folder for the deployed application: " + this.pwa.getId()));
        }
    }

    public void destroy() throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("destroying layout(s), found in :  " + this.pwa.getId()));
        }
        try {
            LayoutService server = this.factory.getLayoutService();
            server.removeLayouts(this.pwa.getId());
        }
        catch (LayoutException e) {
            throw new DeploymentException((Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("done destroying layout(s), found in :  " + this.pwa.getId()));
        }
    }
}

