/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jboss.ws.core.jaxws.WrapperGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWrapperGenerator
implements WrapperGenerator {
    private static Set<String> excludedGetters = new HashSet<String>(4);
    protected ClassLoader loader;

    public AbstractWrapperGenerator(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public void reset(ClassLoader loader) {
        this.loader = loader;
    }

    protected SortedMap<String, Class<?>> getExceptionProperties(Class<?> exception) {
        if (!Exception.class.isAssignableFrom(exception)) {
            throw new IllegalArgumentException("Not an exception");
        }
        TreeMap sortedGetters = new TreeMap();
        for (Method method : exception.getMethods()) {
            int offset;
            String name;
            Class<?> returnType;
            if (Modifier.isStatic(method.getModifiers()) || (returnType = method.getReturnType()) == Void.TYPE || excludedGetters.contains(name = method.getName())) continue;
            if (name.startsWith("get")) {
                offset = 3;
            } else {
                if (!name.startsWith("is")) continue;
                offset = 2;
            }
            name = Introspector.decapitalize(name.substring(offset));
            sortedGetters.put(name, returnType);
        }
        return sortedGetters;
    }

    static {
        excludedGetters.add("getCause");
        excludedGetters.add("getClass");
        excludedGetters.add("getLocalizedMessage");
        excludedGetters.add("getStackTrace");
    }
}

