/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.taglib;

import fr.gouv.education.foad.taglib.MimeTypeValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.servlet.jsp.JspException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.taglib.common.PortalSimpleTag;

public class GetMimeTypeIconTag
extends PortalSimpleTag {
    private static Map<String, MimeTypeValue> mimeTypes;
    private String mimeType;

    public void doTag() throws JspException, IOException {
        String icon;
        String display;
        String description;
        String extension;
        MimeType mimeTypeObject;
        if (mimeTypes == null) {
            GetMimeTypeIconTag.mimeTypesInitialization();
        }
        MimeTypeValue value = mimeTypes.get(this.mimeType);
        Element element = DOM4JUtils.generateElement((String)"span", (String)"document-type", (String)"");
        if (value == null) {
            try {
                mimeTypeObject = new MimeType(this.mimeType);
            }
            catch (MimeTypeParseException e) {
                mimeTypeObject = null;
            }
        } else {
            mimeTypeObject = value.getMimeType();
        }
        if (mimeTypeObject != null) {
            DOM4JUtils.addDataAttribute((Element)element, (String)"primary-type", (String)mimeTypeObject.getPrimaryType());
            DOM4JUtils.addDataAttribute((Element)element, (String)"sub-type", (String)mimeTypeObject.getSubType());
        }
        if (StringUtils.isNotEmpty((String)(extension = value == null ? null : value.getExtension()))) {
            DOM4JUtils.addDataAttribute((Element)element, (String)"extension", (String)extension);
        }
        if (StringUtils.isNotEmpty((String)(description = value == null ? null : value.getDescription()))) {
            DOM4JUtils.addAttribute((Element)element, (String)"title", (String)description);
        }
        if (StringUtils.isNotEmpty((String)(display = value == null ? null : value.getDisplay()))) {
            DOM4JUtils.addDataAttribute((Element)element, (String)"display", (String)display);
            DOM4JUtils.addDataAttribute((Element)element, (String)"length", (String)String.valueOf(display.length()));
        }
        if (StringUtils.isNotEmpty((String)(icon = StringUtils.isNotEmpty((String)display) || value == null ? null : value.getIcon()))) {
            Element iconElement = DOM4JUtils.generateElement((String)"i", (String)icon, (String)"");
            element.add(iconElement);
            DOM4JUtils.addDataAttribute((Element)element, (String)"length", (String)String.valueOf(1));
        }
        if (value == null) {
            DOM4JUtils.addDataAttribute((Element)element, (String)"unknown", (String)"");
            DOM4JUtils.addDataAttribute((Element)element, (String)"length", (String)String.valueOf(1));
        }
        HTMLWriter htmlWriter = new HTMLWriter((Writer)this.getJspContext().getOut());
        htmlWriter.setEscapeText(false);
        htmlWriter.write(element);
    }

    private static synchronized void mimeTypesInitialization() throws IOException {
        if (mimeTypes == null) {
            InputStream input = GetMimeTypeIconTag.class.getResourceAsStream("/mime-types.csv");
            CSVParser parser = CSVParser.parse((InputStream)input, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.EXCEL.withHeader(new String[0]));
            HashMap<String, MimeTypeValue> map = new HashMap<String, MimeTypeValue>();
            for (CSVRecord record : parser) {
                String mimeType = record.get("mime-type");
                String extension = record.get("extension");
                String description = record.get("description");
                String display = record.get("display");
                String icon = record.get("icon");
                MimeTypeValue value = new MimeTypeValue(mimeType, extension, description, display, icon);
                map.put(mimeType, value);
            }
            mimeTypes = map;
        }
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

