/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.proxy;

import edu.yale.its.tp.cas.util.SecureURL;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyEchoFilter
implements Filter {
    private static final Log log = LogFactory.getLog((Class)ProxyEchoFilter.class);
    public static final String INIT_PARAM_ECHO_TARGETS = "edu.yale.its.tp.cas.proxy.echo.targets";
    private Set receivedPgtIous = Collections.synchronizedSet(new HashSet());
    private Set echoTargets = new HashSet();

    public void init(FilterConfig config) throws ServletException {
        String echoTargetsParam;
        if (log.isTraceEnabled()) {
            log.trace((Object)("initializing ProxyExchoFilter using config " + config));
        }
        if ((echoTargetsParam = config.getInitParameter(INIT_PARAM_ECHO_TARGETS)) == null) {
            throw new ServletException("The ProxyEchoFilter requires initialization parameter edu.yale.its.tp.cas.proxy.echo.targets to be a whitespace delimited list of echo targets.");
        }
        StringTokenizer st = new StringTokenizer(echoTargetsParam);
        while (st.hasMoreTokens()) {
            String target = st.nextToken();
            this.echoTargets.add(target);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("returning from init() having initialized " + this));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain fc) throws IOException, ServletException {
        String pgtIou = request.getParameter("pgtIou");
        if (this.receivedPgtIous.add(pgtIou)) {
            int successes = this.echoRequest(pgtIou, request.getParameter("pgtId"));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Echoed the PGT request to " + successes + " of " + this.echoTargets.size() + " targets."));
            }
            fc.doFilter(request, response);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Have already seen pgtIou=[" + pgtIou + "] and so am not echoing it."));
        }
    }

    private int echoRequest(String pgtIou, String pgtID) {
        int successes = 0;
        Iterator iter = this.echoTargets.iterator();
        while (iter.hasNext()) {
            StringBuffer target = new StringBuffer();
            target.append((String)iter.next());
            if (target.indexOf("?") == -1) {
                target.append("?");
            } else {
                target.append("&");
            }
            target.append("pgtIou").append("=").append(pgtIou);
            target.append("&").append("pgtId").append("=").append(pgtID);
            try {
                SecureURL.retrieve(target.toString(), false);
                ++successes;
            }
            catch (Throwable t) {
                log.error((Object)("Failed to retrieve [" + target.toString() + "]"), t);
            }
        }
        return successes;
    }

    public void destroy() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" echoTargets=");
        sb.append(this.echoTargets);
        sb.append(" receivedPgtIous=");
        sb.append(this.receivedPgtIous);
        return sb.toString();
    }
}

