/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.proxy;

import edu.yale.its.tp.cas.proxy.ProxyGrantingTicket;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyTicketReceptor
extends HttpServlet {
    public static final String CAS_PROXYURL_INIT_PARAM = "edu.yale.its.tp.cas.proxyUrl";
    static final String PGT_IOU_PARAM = "pgtIou";
    static final String PGT_ID_PARAM = "pgtId";
    private static Map pgtMap = Collections.synchronizedMap(new HashMap());
    private String casProxyUrl;
    private static final Log log = LogFactory.getLog((Class)ProxyTicketReceptor.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering init(" + config + ")"));
        }
        this.casProxyUrl = config.getInitParameter(CAS_PROXYURL_INIT_PARAM);
        if (this.casProxyUrl == null) {
            ServletContext app = config.getServletContext();
            this.casProxyUrl = app.getInitParameter(CAS_PROXYURL_INIT_PARAM);
            if (this.casProxyUrl == null) {
                throw new ServletException("The servlet (or application context) initialization parameter edu.yale.its.tp.cas.proxyUrl must be set.");
            }
        }
        if (!this.casProxyUrl.toUpperCase().startsWith("HTTPS:")) {
            throw new ServletException("Initialization parameter edu.yale.its.tp.cas.proxyUrl must specify an https: address; its current, unacceptable value is [" + this.casProxyUrl + "]");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("returning from init() having configured a ProxyTicketReceptor as [" + (Object)((Object)this) + "]"));
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pgtId = request.getParameter(PGT_ID_PARAM);
        String pgtIou = request.getParameter(PGT_IOU_PARAM);
        if (pgtId != null && pgtIou != null) {
            ProxyGrantingTicket pgt = new ProxyGrantingTicket(pgtId, this.casProxyUrl);
            log.debug((Object)("adding pgtIou=[" + pgtIou + "], pgt=[" + pgt + "] to the cache."));
            pgtMap.put(pgtIou, pgt);
            PrintWriter out = response.getWriter();
            out.println("<casClient:proxySuccess xmlns:casClient=\"http://www.yale.edu/tp/casClient\"/>");
            out.flush();
        }
    }

    public static String getProxyTicket(String pgtIou, String target) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering getProxyTicket(pgtIou=[" + pgtIou + "], target=[" + target + "]"));
        }
        ProxyGrantingTicket pgt = (ProxyGrantingTicket)pgtMap.get(pgtIou);
        String proxyTicket = null;
        if (pgt == null) {
            log.error((Object)("No ProxyGrantingTicket found for pgtIou=[" + pgtIou + "]"));
        } else {
            proxyTicket = pgt.getProxyTicket(target);
        }
        log.trace((Object)("returning from getProxyTicket() with proxy ticket [" + proxyTicket + "]"));
        return proxyTicket;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(((Object)((Object)this)).getClass().getName());
        sb.append(" ");
        sb.append("casProxyUrl=[");
        sb.append(this.casProxyUrl);
        sb.append("]");
        sb.append(" static map from pgtIous to ProxyGrantingTickets: ");
        sb.append(pgtMap);
        return sb.toString();
    }
}

