/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.User;

public class IdentityCacheService {
    private static final Logger log = Logger.getLogger(IdentityCacheService.class);
    public static final String JNDI_NAME = "java:portal/IdentityCacheService";
    protected ThreadLocal<Map<String, User>> userNameCache = new ThreadLocal();
    protected ThreadLocal<Map<Object, User>> userIdCache = new ThreadLocal();
    protected ThreadLocal<Map<Object, Map>> profileCache = new ThreadLocal();
    protected ThreadLocal<Map<String, Role>> roleNameCache = new ThreadLocal();
    protected ThreadLocal<Map<Object, Role>> roleIdCache = new ThreadLocal();
    protected ThreadLocal<Set> roles = new ThreadLocal();

    public void cleanup() {
        this.userNameCache.set(null);
        this.userIdCache.set(null);
        this.profileCache.set(null);
        this.roleNameCache.set(null);
        this.roleIdCache.set(null);
        this.roles.set(null);
        log.debug((Object)"Identity cache invalidated");
    }

    private Map<String, User> getUserNameCache() {
        if (this.userNameCache.get() == null) {
            this.userNameCache.set(new HashMap());
        }
        return this.userNameCache.get();
    }

    private Map<Object, User> getUserIdCache() {
        if (this.userIdCache.get() == null) {
            this.userIdCache.set(new HashMap());
        }
        return this.userIdCache.get();
    }

    private Map<Object, Map> getProfileCache() {
        if (this.profileCache.get() == null) {
            this.profileCache.set(new HashMap());
        }
        return this.profileCache.get();
    }

    private Map<String, Role> getRoleNameCache() {
        if (this.roleNameCache.get() == null) {
            this.roleNameCache.set(new HashMap());
        }
        return this.roleNameCache.get();
    }

    private Map<Object, Role> getRoleIdCache() {
        if (this.roleIdCache.get() == null) {
            this.roleIdCache.set(new HashMap());
        }
        return this.roleIdCache.get();
    }

    public void storeUser(User user) {
        if (user != null) {
            this.getUserIdCache().put(user.getId(), user);
            this.getUserNameCache().put(user.getUserName(), user);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User cached for id=" + user.getId() + "; username=" + user.getUserName()));
            }
        }
    }

    public void invalidateUser(User user) {
        if (user != null) {
            this.getUserIdCache().put(user.getId(), null);
            this.getUserNameCache().put(user.getUserName(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User invalidated in cache for id=" + user.getId() + "; username=" + user.getUserName()));
            }
        }
    }

    public void storeProfile(User user, Map profile) {
        if (user != null && profile != null) {
            this.getProfileCache().put(user.getId(), profile);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User profile cached for id=" + user.getId()));
            }
        }
    }

    public void invalidateProfile(User user) {
        if (user != null) {
            this.getProfileCache().put(user.getId(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User profile invalidated in cache for id=" + user.getId()));
            }
        }
    }

    public void storeRole(Role role) {
        if (role != null) {
            this.getRoleIdCache().put(role.getId(), role);
            this.getRoleNameCache().put(role.getName(), role);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Role cached for id=" + role.getId() + "; name=" + role.getName()));
            }
        }
    }

    public void invalidateRole(Role role) {
        if (role != null) {
            this.getRoleIdCache().put(role.getId(), null);
            this.getRoleNameCache().put(role.getName(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Role invalidated in cache for id=" + role.getId() + "; name=" + role.getName()));
            }
        }
    }

    public User findUserByUserName(String userName) {
        User user = this.getUserNameCache().get(userName);
        if (user != null && log.isDebugEnabled()) {
            log.debug((Object)("User retrieved from cache for username=" + user.getUserName()));
        }
        return user;
    }

    public User findUserById(Object id) {
        User user = this.getUserIdCache().get(id);
        if (user != null && log.isDebugEnabled()) {
            log.debug((Object)("User retrieved from cache for id=" + user.getId()));
        }
        return user;
    }

    public Map findUserProfileById(Object id) {
        Map profile = this.getProfileCache().get(id);
        if (profile != null && log.isDebugEnabled()) {
            log.debug((Object)("User profile retrieved from cache for user id=" + id));
        }
        return profile;
    }

    public Role findRoleByName(String roleName) {
        Role role = this.getRoleNameCache().get(roleName);
        if (role != null && log.isDebugEnabled()) {
            log.debug((Object)("Role retrieved from cache for name=" + role.getName()));
        }
        return role;
    }

    public Role findRoleById(Object id) {
        Role role = this.getRoleIdCache().get(id);
        if (role != null && log.isDebugEnabled()) {
            log.debug((Object)("Role retrieved from cache for id=" + role.getId()));
        }
        return role;
    }

    public void storeRoles(User user, Map profile) {
        if (user != null && profile != null) {
            this.getProfileCache().put(user.getId(), profile);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User profile cached for id=" + user.getId()));
            }
        }
    }

    public Set getRoles() {
        return this.roles.get();
    }

    public void storeRoles(Set rolesToSet) {
        this.roles.set(rolesToSet);
    }
}

