/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.instance.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.portal.common.i18n.LocaleFormat;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.common.util.ConversionException;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.portlet.deployment.LocalizedStringBuilder;
import org.jboss.portal.portlet.impl.metadata.common.LocalizedDescriptionMetaData;
import org.jboss.portal.portlet.impl.metadata.portlet.PortletPreferenceMetaData;
import org.jboss.portal.portlet.impl.metadata.portlet.PortletPreferencesMetaData;
import org.jboss.portal.security.metadata.SecurityConstraintsMetaData;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.w3c.dom.Element;

public class InstanceMetaData {
    private static final Logger log = Logger.getLogger(InstanceMetaData.class);
    private String id;
    private PortletPreferencesMetaData preferences;
    private String portletRef;
    private SecurityConstraintsMetaData securityConstraints;
    private LocalizedString displayName;
    private String resourceBundle;
    private List supportedLocales;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PortletPreferencesMetaData getPreferences() {
        return this.preferences;
    }

    public void setPreferences(PortletPreferencesMetaData preferences) {
        this.preferences = preferences;
    }

    public String getPortletRef() {
        return this.portletRef;
    }

    public void setPortletRef(String portletRef) {
        this.portletRef = portletRef;
    }

    public LocalizedString getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(LocalizedString displayName) {
        this.displayName = displayName;
    }

    public SecurityConstraintsMetaData getSecurityConstraints() {
        return this.securityConstraints;
    }

    public void setSecurityConstraints(SecurityConstraintsMetaData securityConstraints) {
        this.securityConstraints = securityConstraints;
    }

    public static InstanceMetaData buildMetaData(Element instanceElt, PortalWebApp pwa) {
        String instanceName = XMLTools.asString((Element)XMLTools.getUniqueChild((Element)instanceElt, (String)"instance-id", (boolean)true));
        String componentRef = XMLTools.asString((Element)XMLTools.getUniqueChild((Element)instanceElt, (String)"portlet-ref", (boolean)true));
        Element resourceBundleElement = XMLTools.getUniqueChild((Element)instanceElt, (String)"resource-bundle", (boolean)false);
        String resourceBundle = null;
        if (resourceBundleElement != null) {
            resourceBundle = XMLTools.asString((Element)resourceBundleElement);
        }
        Iterator displayNamesIt = XMLTools.getChildrenIterator((Element)instanceElt, (String)"display-name");
        PortletPreferencesMetaData preferencesMD = new PortletPreferencesMetaData();
        Element preferencesElt = XMLTools.getUniqueChild((Element)instanceElt, (String)"preferences", (boolean)false);
        if (preferencesElt != null) {
            for (PortletPreferenceMetaData preferenceMD : InstanceMetaData.buildPreferencesMetaData(preferencesElt).values()) {
                preferencesMD.addPortletPreference(preferenceMD);
            }
        }
        LocalizedStringBuilder localizedStringMD = new LocalizedStringBuilder();
        String dummy = new String("Dummy");
        while (displayNamesIt.hasNext()) {
            Element element = (Element)displayNamesIt.next();
            LocalizedDescriptionMetaData displayNameMD = new LocalizedDescriptionMetaData();
            String lang = element.getAttribute("xml:lang");
            try {
                Locale locale = LocaleFormat.DEFAULT.getLocale(lang);
                displayNameMD.setLang(locale.toString());
                displayNameMD.setDescription(element.getTextContent());
                localizedStringMD.put((Object)dummy, displayNameMD);
            }
            catch (ConversionException e) {
                log.error((Object)("Cannot set localized display-name, for language: " + lang), (Throwable)e);
            }
        }
        Iterator supportedLocalesIt = XMLTools.getChildrenIterator((Element)instanceElt, (String)"supported-locale");
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        while (supportedLocalesIt.hasNext()) {
            String localeName = ((Element)supportedLocalesIt.next()).getTextContent();
            supportedLocales.add(new Locale(localeName));
        }
        InstanceMetaData instanceMD = new InstanceMetaData();
        instanceMD.setId(instanceName);
        instanceMD.setPortletRef(componentRef);
        instanceMD.setPreferences(preferencesMD);
        instanceMD.setDisplayName(localizedStringMD.getLocalizedString((Object)dummy));
        instanceMD.setResourceBundle(resourceBundle);
        instanceMD.setSupportedLocales(supportedLocales);
        Element securityConstraintElt = XMLTools.getUniqueChild((Element)instanceElt, (String)"security-constraint", (boolean)false);
        if (securityConstraintElt != null) {
            SecurityConstraintsMetaData securityConstraintsMD = SecurityConstraintsMetaData.buildSecurityConstraintMetaData((Element)securityConstraintElt);
            instanceMD.setSecurityConstraints(securityConstraintsMD);
        }
        return instanceMD;
    }

    public static InstanceMetaData buildLegacyMetaData(Element instanceElt, String pwaId) {
        Element instanceNameElt = XMLTools.getUniqueChild((Element)instanceElt, (String)"instance-name", (boolean)true);
        Element componentRefElt = XMLTools.getUniqueChild((Element)instanceElt, (String)"component-ref", (boolean)true);
        String instanceName = XMLTools.asString((Element)instanceNameElt);
        String componentRef = XMLTools.asString((Element)componentRefElt);
        int dotIndex = componentRef.indexOf(46);
        if (dotIndex == -1) {
            log.warn((Object)("Bad component ref " + componentRef));
        } else {
            String appId = componentRef.substring(0, dotIndex);
            if (!appId.equals(pwaId)) {
                log.warn((Object)("The instance " + instanceName + " will not be created because the component referenced is outside of the same web app " + componentRef));
            } else {
                String portletRef = componentRef.substring(dotIndex + 1);
                if (portletRef.length() == 0) {
                    log.warn((Object)("Zero portlet ref length are not considered " + componentRef));
                } else {
                    Element securityConstraintElt;
                    log.debug((Object)("Adding legacy instance " + instanceName));
                    InstanceMetaData instanceMD = new InstanceMetaData();
                    instanceMD.setId(instanceName);
                    instanceMD.setPortletRef(portletRef);
                    PortletPreferencesMetaData preferencesMD = new PortletPreferencesMetaData();
                    Element preferencesElt = XMLTools.getUniqueChild((Element)instanceElt, (String)"preferences", (boolean)false);
                    if (preferencesElt != null) {
                        for (PortletPreferenceMetaData preferenceMD : InstanceMetaData.buildPreferencesMetaData(preferencesElt).values()) {
                            preferencesMD.addPortletPreference(preferenceMD);
                        }
                    }
                    if ((securityConstraintElt = XMLTools.getUniqueChild((Element)instanceElt, (String)"security-constraint", (boolean)false)) != null) {
                        SecurityConstraintsMetaData securityConstraintsMD = SecurityConstraintsMetaData.buildSecurityConstraintMetaData((Element)securityConstraintElt);
                        instanceMD.setSecurityConstraints(securityConstraintsMD);
                    }
                    return instanceMD;
                }
            }
        }
        return null;
    }

    public static Map buildPreferencesMetaData(Element portletPreferencesElt) {
        HashMap<String, PortletPreferenceMetaData> preferences = new HashMap<String, PortletPreferenceMetaData>();
        Iterator i = XMLTools.getChildrenIterator((Element)portletPreferencesElt, (String)"preference");
        while (i.hasNext()) {
            Element preferenceElt = (Element)i.next();
            PortletPreferenceMetaData preference = InstanceMetaData.buildPreferenceMetaData(preferenceElt);
            preferences.put(preference.getName(), preference);
        }
        return preferences;
    }

    public static PortletPreferenceMetaData buildPreferenceMetaData(Element preferenceElt) {
        String value;
        PortletPreferenceMetaData preferenceMD = new PortletPreferenceMetaData();
        List valuesElt = XMLTools.getChildren((Element)preferenceElt, (String)"value");
        String[] values = new String[valuesElt.size()];
        for (int i = 0; i < valuesElt.size(); ++i) {
            values[i] = XMLTools.asString((Element)((Element)valuesElt.get(i)));
        }
        Element readOnlyElt = XMLTools.getUniqueChild((Element)preferenceElt, (String)"read-only", (boolean)false);
        boolean readOnly = false;
        readOnly = readOnlyElt != null ? ("true".equals(value = XMLTools.asString((Element)readOnlyElt)) ? true : ("false".equals(value) ? false : false)) : false;
        preferenceMD.setName(XMLTools.asString((Element)XMLTools.getUniqueChild((Element)preferenceElt, (String)"name", (boolean)true)));
        preferenceMD.setReadOnly(readOnly);
        preferenceMD.setValue(Arrays.asList(values));
        return preferenceMD;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public List getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setSupportedLocales(List supportedLocales) {
        this.supportedLocales = supportedLocales;
    }
}

