/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.faces.component.portlet;

import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.portlet.OpaqueStateString;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.StateString;

public class PortletRequestDecoder {
    public static final int ACTION_MASK = 1;
    public static final int RENDER_MASK = 2;
    public static final int MODE_MASK = 4;
    public static final int WINDOW_STATE_MASK = 8;
    public static final int OPAQUE_MASK = 16;
    public static final String MODE_PARAMETER = "mode";
    public static final String WINDOW_STATE_PARAMETER = "windowstate";
    public static final String INTERACTION_STATE_PARAMETER = "is";
    public static final String NAVIGATIONAL_STATE_PARAMETER = "ns";
    public static final String META_PARAMETER = "action";
    public static final int ACTION_TYPE = 0;
    public static final int RENDER_TYPE = 1;
    public static final int NAV_TYPE = 2;
    private Mode mode;
    private WindowState windowState;
    private StateString navigationalstate;
    private StateString interactionState;
    private ParameterMap form;
    private int type;

    public void decode(Map queryParams, Map bodyParams) throws IllegalArgumentException {
        int meta = 0;
        String[] metaParam = (String[])queryParams.get(META_PARAMETER);
        if (metaParam != null) {
            try {
                meta = Integer.parseInt(metaParam[0], 16);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        if ((meta & 3) != 0) {
            boolean opaque;
            if ((meta & 3) == 3) {
                throw new IllegalArgumentException("Cannot have both action and render in the mask at the same time");
            }
            this.type = (meta & 1) != 0 ? 0 : 1;
            if ((meta & 4) != 0) {
                String[] modeParam = (String[])queryParams.get(MODE_PARAMETER);
                if (modeParam == null) {
                    throw new IllegalArgumentException();
                }
                this.mode = Mode.create((String)modeParam[0]);
            } else {
                this.mode = null;
            }
            if ((meta & 8) != 0) {
                String[] windowStateParam = (String[])queryParams.get(WINDOW_STATE_PARAMETER);
                if (windowStateParam == null) {
                    throw new IllegalArgumentException();
                }
                this.windowState = WindowState.create((String)windowStateParam[0]);
            } else {
                this.windowState = null;
            }
            boolean bl = opaque = (meta & 0x10) != 0;
            if (!opaque) {
                ParametersStateString query = ParametersStateString.create();
                for (Map.Entry entry : queryParams.entrySet()) {
                    int index = 0;
                    String name = (String)entry.getKey();
                    String[] queryValues = (String[])entry.getValue();
                    if (META_PARAMETER.equals(name)) {
                        index = 1;
                    } else if ((meta & 4) != 0 && MODE_PARAMETER.equals(name)) {
                        index = 1;
                    } else if ((meta & 8) != 0 && WINDOW_STATE_PARAMETER.equals(name)) {
                        index = 1;
                    }
                    if (index >= queryValues.length) continue;
                    String[] values = new String[queryValues.length - index];
                    System.arraycopy(queryValues, index, values, 0, values.length);
                    query.setValues(name, values);
                }
                ParameterMap form = new ParameterMap();
                if (bodyParams != null) {
                    form.putAll(bodyParams);
                }
                if (this.type == 0) {
                    this.navigationalstate = null;
                    this.interactionState = query;
                    this.form = form;
                } else {
                    this.navigationalstate = query;
                    this.interactionState = null;
                    this.form = null;
                }
            } else {
                String[] ns = (String[])queryParams.get(NAVIGATIONAL_STATE_PARAMETER);
                this.navigationalstate = ns != null ? new OpaqueStateString(ns[0]) : null;
                if (this.type == 0) {
                    String[] is = (String[])queryParams.get(INTERACTION_STATE_PARAMETER);
                    this.interactionState = is != null ? new OpaqueStateString(is[0]) : null;
                    this.form = new ParameterMap();
                    if (bodyParams != null) {
                        this.form.putAll(bodyParams);
                    }
                } else {
                    this.interactionState = null;
                    this.form = null;
                }
            }
        } else {
            this.type = 2;
            String[] modeParam = (String[])queryParams.get(MODE_PARAMETER);
            this.mode = modeParam != null ? Mode.create((String)modeParam[0]) : null;
            String[] windowStateParam = (String[])queryParams.get(WINDOW_STATE_PARAMETER);
            this.windowState = windowStateParam != null ? WindowState.create((String)windowStateParam[0]) : null;
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public StateString getNavigationalState() {
        return this.navigationalstate;
    }

    public StateString getInteractionState() {
        return this.interactionState;
    }

    public ParameterMap getForm() {
        return this.form;
    }

    public int getType() {
        return this.type;
    }
}

