/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.logging.Logger;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.theme.PortalTheme;
import org.jboss.portal.theme.RuntimeContext;
import org.jboss.portal.theme.ServerRegistrationID;
import org.jboss.portal.theme.ThemeException;
import org.jboss.portal.theme.ThemeInfo;
import org.jboss.portal.theme.ThemeService;
import org.jboss.portal.theme.metadata.PortalThemeMetaData;
import org.jboss.system.Service;

public class ThemeServiceImpl
extends AbstractJBossService
implements ThemeService,
Service {
    private static Logger log = Logger.getLogger(ThemeServiceImpl.class);
    private Map themes;
    private Map themeNames;
    private Map exactThemeNames;
    private ServerRegistrationID defaultID;
    private PortalTheme defaultTheme;
    private String defaultThemeName;

    public ThemeServiceImpl() {
        log.debug((Object)"ThemeServiceImpl instantiated.");
    }

    protected void createService() throws Exception {
        log.debug((Object)"create ThemeServiceImpl ....");
        this.themes = Collections.synchronizedMap(new HashMap());
        this.themeNames = Collections.synchronizedMap(new HashMap());
        this.exactThemeNames = Collections.synchronizedMap(new HashMap());
    }

    protected void destroyService() {
        log.debug((Object)"destroy ThemeServiceImpl ....");
        this.themes.clear();
        this.themeNames.clear();
        this.exactThemeNames.clear();
    }

    protected void startService() throws Exception {
        log.debug((Object)"start ThemeServiceImpl ....");
    }

    protected void stopService() {
        log.debug((Object)"stop ThemeServiceImpl ....");
    }

    public void addTheme(RuntimeContext runtimeContext, PortalThemeMetaData metaData) throws ThemeException {
        try {
            log.debug((Object)("add theme: " + metaData));
            PortalTheme theme = (PortalTheme)runtimeContext.getClassLoader().loadClass(metaData.getClassName()).newInstance();
            if (this.themes == null) {
                try {
                    this.create();
                }
                catch (Exception e) {
                    throw new ThemeException(e);
                }
            }
            ThemeInfo info = new ThemeInfo(runtimeContext, metaData);
            theme.init(this, info);
            if (!ServerRegistrationID.TYPE_THEME.equals(info.getRegistrationId().getType())) {
                throw new ThemeException("wrong meta data type: " + info.getRegistrationId().getType());
            }
            this.themeNames.put(metaData.getName(), info.getRegistrationId());
            this.themes.put(info.getRegistrationId(), theme);
            String key = info.getAppId() + "." + metaData.getName();
            this.exactThemeNames.put(key, info.getRegistrationId());
        }
        catch (Exception e) {
            throw new ThemeException(e);
        }
    }

    public void removeTheme(PortalTheme theme) {
        ServerRegistrationID themeId = theme.getThemeInfo().getRegistrationId();
        if (this.themes.containsKey(themeId)) {
            ThemeInfo info = theme.getThemeInfo();
            theme.destroy();
            log.debug((Object)("remove theme " + themeId + ": " + info.getName()));
            String themeName = info.getAppId() + "." + info.getName();
            if (this.exactThemeNames.keySet().contains(themeName)) {
                log.debug((Object)("removing theme exact " + themeName));
                this.exactThemeNames.remove(themeName);
            }
            if (this.themeNames.keySet().contains(info.getName())) {
                log.debug((Object)("removing theme " + info.getName()));
                this.themeNames.remove(info.getName());
            }
            this.themes.remove(themeId);
            if (this.defaultID != null && this.defaultID.equals(themeId)) {
                log.debug((Object)"removed default theme; need to set a new default...");
                Iterator keySet = this.themes.keySet().iterator();
                if (keySet.hasNext()) {
                    this.defaultID = (ServerRegistrationID)keySet.next();
                    log.debug((Object)("set new default to " + this.defaultID));
                } else {
                    this.defaultID = null;
                }
            }
        }
    }

    public void removeThemes(String appId) {
        ArrayList<PortalTheme> themesToDelete = new ArrayList<PortalTheme>();
        Iterator allThemes = this.themes.keySet().iterator();
        while (allThemes.hasNext()) {
            PortalTheme theme = (PortalTheme)this.themes.get(allThemes.next());
            if (!theme.getThemeInfo().getAppId().equals(appId)) continue;
            themesToDelete.add(theme);
        }
        for (PortalTheme t : themesToDelete) {
            this.removeTheme(t);
        }
    }

    public void setDefault(ServerRegistrationID themeId) throws ThemeException {
        log.debug((Object)("set default theme " + themeId));
        if (this.themes.keySet().contains(themeId)) {
            this.defaultID = themeId;
            log.debug((Object)("set new default theme to " + this.defaultID));
            return;
        }
        throw new ThemeException("Theme with name [" + themeId + "] does not exist");
    }

    public void setDefaultThemeName(String defaultName) throws ThemeException {
        log.debug((Object)("setting default: " + defaultName));
        this.defaultThemeName = defaultName;
        this.defaultTheme = null;
    }

    public PortalTheme getDefaultTheme() {
        if (this.defaultTheme == null) {
            if (this.exactThemeNames.keySet().contains(this.defaultThemeName)) {
                ServerRegistrationID defaultID = (ServerRegistrationID)this.exactThemeNames.get(this.defaultThemeName);
                this.defaultTheme = (PortalTheme)this.themes.get(defaultID);
            } else if (this.themeNames.keySet().contains(this.defaultThemeName)) {
                ServerRegistrationID defaultID = (ServerRegistrationID)this.themeNames.get(this.defaultThemeName);
                this.defaultTheme = (PortalTheme)this.themes.get(defaultID);
            }
        }
        if (this.defaultTheme == null) {
            log.error((Object)("Couldn't find the default layout named:" + this.defaultThemeName));
        }
        return this.defaultTheme;
    }

    public void setDefaultFromName(String name) throws ThemeException {
        log.debug((Object)("set default theme " + name));
        if (this.exactThemeNames.keySet().contains(name)) {
            this.defaultID = (ServerRegistrationID)this.exactThemeNames.get(name);
            return;
        }
        if (this.themeNames.keySet().contains(name)) {
            this.defaultID = (ServerRegistrationID)this.themeNames.get(name);
            return;
        }
        throw new ThemeException("Theme with name [" + name + "] does not exist");
    }

    public PortalTheme getTheme(ServerRegistrationID themeId, boolean defaultOnNull) {
        log.debug((Object)("get theme " + themeId));
        if (themeId == null) {
            throw new IllegalArgumentException("Theme ID must not be null");
        }
        if (!this.themes.keySet().contains(themeId) && defaultOnNull && this.defaultID != null) {
            return (PortalTheme)this.themes.get(this.defaultID);
        }
        return (PortalTheme)this.themes.get(themeId);
    }

    public PortalTheme getTheme(String name, boolean defaultOnNull) {
        log.debug((Object)("get theme " + name));
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (this.exactThemeNames.keySet().contains(name)) {
            log.debug((Object)("found theme exact " + name));
            return (PortalTheme)this.themes.get(this.exactThemeNames.get(name));
        }
        if (this.themeNames.keySet().contains(name)) {
            log.debug((Object)("found theme " + name));
            return (PortalTheme)this.themes.get(this.themeNames.get(name));
        }
        if (defaultOnNull && this.defaultID != null) {
            log.debug((Object)("returning default theme " + this.defaultID));
            return (PortalTheme)this.themes.get(this.defaultID);
        }
        log.warn((Object)("Theme with name [" + name + "] not found"));
        return null;
    }

    public PortalTheme getThemeById(String themeIdString) {
        PortalTheme theme;
        if (themeIdString == null) {
            theme = this.getDefaultTheme();
        } else if (themeIdString.lastIndexOf(".") > 0) {
            ServerRegistrationID themeId = ServerRegistrationID.createID(ServerRegistrationID.TYPE_THEME, ThemeServiceImpl.parseId(themeIdString));
            theme = this.getTheme(themeId, true);
        } else {
            theme = this.getTheme(themeIdString, true);
        }
        if (theme == null) {
            theme = this.getTheme("renaissance", true);
        }
        if (theme == null) {
            throw new IllegalStateException("No Theme found for " + themeIdString);
        }
        return theme;
    }

    public Collection getThemes() {
        return Collections.unmodifiableCollection(this.themes.values());
    }

    public Collection getThemeNames() {
        return Collections.unmodifiableCollection(this.themeNames.keySet());
    }

    public static String[] parseId(String layoutIDString) {
        ArrayList<String> names = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(layoutIDString, ".");
        if (tokens.countTokens() > 1) {
            while (tokens.hasMoreElements()) {
                names.add(tokens.nextToken());
            }
        } else {
            names.add(layoutIDString);
        }
        String[] id = new String[names.size()];
        names.toArray(id);
        return id;
    }
}

