/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.forms;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterExecutor;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoServiceFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;

public class FormFilterContext {
    private PortalControllerContext portalControllerContext;
    private Map<String, String> variables;
    private Map<String, Map<String, String>> filtersParams;
    private String modelWebId;
    private String procedureInstanceUuid;
    private String actionId;
    private String procedureInitiator;
    private String taskInitiator;
    private String nextStep;
    private final Set<String> actors;
    private final Set<String> additionalAuthorizations;
    private final IFormsService formsService;

    public FormFilterContext(Map<String, Map<String, String>> filtersParams, String procedureInitiator, String taskInitiator, String nextStep) {
        this.filtersParams = filtersParams;
        this.procedureInitiator = procedureInitiator;
        this.nextStep = nextStep;
        this.taskInitiator = taskInitiator;
        this.actors = new HashSet<String>();
        this.additionalAuthorizations = new HashSet<String>();
        this.formsService = NuxeoServiceFactory.getFormsService();
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public String getModelWebId() {
        return this.modelWebId;
    }

    public void setModelWebId(String modelWebId) {
        this.modelWebId = modelWebId;
    }

    public String getProcedureInstanceUuid() {
        return this.procedureInstanceUuid;
    }

    public void setProcedureInstanceUuid(String procedureInstanceUuid) {
        this.procedureInstanceUuid = procedureInstanceUuid;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getParamValue(FormFilterExecutor executor, String paramKey) {
        Map<String, String> paramsMap = this.filtersParams.get(executor.getCurrentFilterInstanceId());
        if (paramsMap != null) {
            String filterParameters = paramsMap.get(paramKey);
            try {
                HashMap<String, String> variables = new HashMap<String, String>(this.getVariables());
                variables.put("procedureInitiator", this.procedureInitiator);
                variables.put("taskInitiator", this.taskInitiator);
                return this.formsService.transform(this.portalControllerContext, filterParameters, variables);
            }
            catch (PortalException e) {
                throw new NuxeoException(e);
            }
        }
        return null;
    }

    public PortalControllerContext getPortalControllerContext() {
        return this.portalControllerContext;
    }

    public void setPortalControllerContext(PortalControllerContext portalControllerContext) {
        this.portalControllerContext = portalControllerContext;
    }

    public Map<String, Map<String, String>> getFiltersParams() {
        return this.filtersParams;
    }

    public String getProcedureInitiator() {
        return this.procedureInitiator;
    }

    public String getNextStep() {
        return this.nextStep;
    }

    public void setNextStep(String nextStep) {
        this.nextStep = nextStep;
    }

    public Set<String> getActors() {
        return this.actors;
    }

    public Set<String> getAdditionalAuthorizations() {
        return this.additionalAuthorizations;
    }
}

