/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Constructor;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.ConstructorInfo;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.util.ReflectToJavassist;

public class ConstructorJoinPointGenerator
extends JoinPointGenerator {
    public static final String GENERATOR_PREFIX = "generator_constructor_";
    public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_constructor_";
    public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_constructor_";
    private static final Class INVOCATION_TYPE = ConstructorInvocation.class;
    private static final CtClass INVOCATION_CT_TYPE;

    public ConstructorJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info) {
        super(advisor, info);
    }

    protected void initialiseJoinPointNames() {
        this.joinpointClassName = ConstructorJoinPointGenerator.getInfoClassName(this.classSimpleName(), this.index());
        this.joinpointFieldName = ConstructorJoinPointGenerator.getInfoFieldName(this.classSimpleName(), this.index());
    }

    private String classSimpleName() {
        Constructor ctor = ((ConstructorInfo)this.info).getConstructor();
        return Advisor.getSimpleName(ctor.getDeclaringClass());
    }

    private int index() {
        return ((ConstructorInfo)this.info).getIndex();
    }

    protected boolean isVoid() {
        return false;
    }

    protected Class getReturnType() {
        return ((ConstructorInfo)this.info).getConstructor().getDeclaringClass();
    }

    protected AdviceMethodProperties getAdviceMethodProperties(JoinPointGenerator.AdviceSetup setup) {
        Constructor ctor = ((ConstructorInfo)this.info).getConstructor();
        return new AdviceMethodProperties(setup.getAspectClass(), setup.getAdviceName(), this.info.getClass(), INVOCATION_TYPE, ctor.getDeclaringClass(), ctor.getParameterTypes(), ctor.getExceptionTypes());
    }

    protected boolean hasTargetObject() {
        return false;
    }

    protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtConstructor advisedCtor, String ciname, int index) throws NotFoundException, CannotCompileException {
        instrumentor.addJoinPointGeneratorFieldToGenAdvisor(ConstructorJoinPointGenerator.getJoinPointGeneratorFieldName(advisedClass.getSimpleName(), index));
        BaseClassGenerator generator = new BaseClassGenerator(instrumentor, advisedClass, advisedCtor, ciname, index);
        return generator.generate();
    }

    protected String getJoinPointGeneratorFieldName() {
        return ConstructorJoinPointGenerator.getJoinPointGeneratorFieldName(this.classSimpleName(), this.index());
    }

    protected static String getInfoFieldName(String className, int index) {
        return JOINPOINT_FIELD_PREFIX + className + "_" + index;
    }

    private static String getInfoClassName(String className, int index) {
        return JOINPOINT_CLASS_PREFIX + className + "_" + index;
    }

    protected static String getJoinPointGeneratorFieldName(String className, int index) {
        return GENERATOR_PREFIX + className + "_" + index;
    }

    static {
        try {
            INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BaseClassGenerator {
        GeneratedAdvisorInstrumentor instrumentor;
        CtClass advisedClass;
        CtConstructor advisedCtor;
        String ciname;
        int index;
        CtClass jp;
        CtMethod invokeJoinpointMethod;
        CtConstructor publicConstructor;
        CtConstructor protectedConstructor;
        CtField targetField;
        CtClass[] params;
        CtClass constructorInfoClass;

        BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtConstructor advisedCtor, String ciname, int index) throws NotFoundException {
            this.instrumentor = instrumentor;
            this.advisedClass = advisedClass;
            this.advisedCtor = advisedCtor;
            this.ciname = ciname;
            this.index = index;
            this.params = advisedCtor.getParameterTypes();
            this.constructorInfoClass = instrumentor.forName("org.jboss.aop.ConstructorInfo");
        }

        protected CtClass generate() throws CannotCompileException, NotFoundException {
            this.jp = this.setupClass();
            this.addArgumentsFieldsAndAccessors();
            this.addInvokeJoinpointMethod();
            this.addMethodInfoField();
            this.addPublicConstructor();
            this.addProtectedConstructor();
            this.addDispatchMethods();
            TransformerCommon.compileOrLoadClass(this.advisedClass, this.jp);
            return this.jp;
        }

        private CtClass setupClass() throws NotFoundException, CannotCompileException {
            String className = ConstructorJoinPointGenerator.getInfoClassName(this.advisedClass.getSimpleName(), this.index);
            this.jp = this.advisedClass.makeNestedClass(className, true);
            int mod = this.jp.getModifiers();
            this.jp.setModifiers(mod | 1);
            CtClass constructorInvocation = INVOCATION_CT_TYPE;
            this.jp.setSuperclass(constructorInvocation);
            JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
            return this.jp;
        }

        private void addArgumentsFieldsAndAccessors() throws NotFoundException, CannotCompileException {
            OptimizedBehaviourInvocations.addArgumentFieldsToInvocation(this.jp, this.params);
            OptimizedBehaviourInvocations.addSetArguments(this.instrumentor.getClassPool(), this.jp, this.params);
            OptimizedBehaviourInvocations.addGetArguments(this.instrumentor.getClassPool(), this.jp, this.params);
        }

        private void addPublicConstructor() throws CannotCompileException {
            this.publicConstructor = CtNewConstructor.make((CtClass[])new CtClass[]{this.constructorInfoClass}, (CtClass[])new CtClass[0], (CtClass)this.jp);
            this.publicConstructor.setBody("{super($1, $1.getInterceptors()); this.info = $1;}");
            this.jp.addConstructor(this.publicConstructor);
        }

        protected void addProtectedConstructor() throws CannotCompileException {
            int offset;
            CtClass[] ctorParams = new CtClass[this.params.length + 1];
            ctorParams[0] = this.jp;
            System.arraycopy(this.params, 0, ctorParams, 1, this.params.length);
            this.protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams, (CtClass[])new CtClass[0], (CtClass)this.jp);
            this.protectedConstructor.setModifiers(4);
            StringBuffer body = new StringBuffer();
            body.append("{");
            body.append("   this($1.info);");
            for (int i = offset = 1; i < ctorParams.length; ++i) {
                body.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
            }
            body.append("}");
            this.protectedConstructor.setBody(body.toString());
            this.jp.addConstructor(this.protectedConstructor);
        }

        private CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException {
            this.invokeJoinpointMethod = CtNewMethod.make((CtClass)this.advisedClass, (String)"invokeJoinpoint", (CtClass[])this.params, (CtClass[])this.advisedCtor.getExceptionTypes(), null, (CtClass)this.jp);
            this.invokeJoinpointMethod.setModifiers(4);
            this.jp.addMethod(this.invokeJoinpointMethod);
            return this.invokeJoinpointMethod;
        }

        private void addMethodInfoField() throws CannotCompileException {
            CtField infoField = new CtField(this.constructorInfoClass, "info", this.jp);
            this.jp.addField(infoField);
        }

        private void addDispatchMethods() throws CannotCompileException, NotFoundException {
            this.addInvokeNextDispatchMethod();
            if (this.params.length > 0) {
                this.addInvokeJoinPointDispatchMethod();
            }
        }

        private void addInvokeNextDispatchMethod() throws CannotCompileException, NotFoundException {
            CtMethod dispatch = CtNewMethod.make((CtClass)this.advisedClass, (String)"dispatch", (CtClass[])new CtClass[0], (CtClass[])this.advisedCtor.getExceptionTypes(), null, (CtClass)this.jp);
            dispatch.setModifiers(4);
            StringBuffer parameters = new StringBuffer("(");
            for (int i = 0; i < this.params.length; ++i) {
                if (i > 0) {
                    parameters.append(", ");
                }
                parameters.append("arg" + i);
            }
            parameters.append(")");
            String body = "{   " + this.advisedClass.getName() + " obj = new " + this.advisedClass.getName() + parameters + ";" + "   setTargetObject(obj);" + "   return obj;" + "}";
            try {
                dispatch.setBody(body);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + dispatch, e);
            }
            this.jp.addMethod(dispatch);
        }

        private void addInvokeJoinPointDispatchMethod() throws CannotCompileException, NotFoundException {
            CtMethod dispatch = CtNewMethod.make((CtClass)this.advisedClass, (String)"dispatch", (CtClass[])this.params, (CtClass[])this.advisedCtor.getExceptionTypes(), null, (CtClass)this.jp);
            dispatch.setModifiers(4);
            String body = "{   " + this.advisedClass.getName() + " obj = new " + this.advisedClass.getName() + "($$);" + "   setTargetObject(obj);" + "   return obj;" + "}";
            try {
                dispatch.setBody(body);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + dispatch, e);
            }
            this.jp.addMethod(dispatch);
        }
    }
}

