/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.jems.hibernate;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;
import org.jboss.portal.jems.hibernate.ByteArrayBlob;

public class CacheableBlobUserType
implements UserType {
    private static final int[] SQL_TYPES = new int[]{2004};

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Class returnedClass() {
        return Blob.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x != null && y != null) {
            try {
                ByteArrayBlob _x = ByteArrayBlob.get((Blob)x);
                ByteArrayBlob _y = ByteArrayBlob.get((Blob)y);
                return Arrays.equals(_x._bytes, _y._bytes);
            }
            catch (Exception e) {
                throw new HibernateException((Throwable)e);
            }
        }
        return false;
    }

    public int hashCode(Object object) throws HibernateException {
        return object.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Blob blob = rs.getBlob(names[0]);
        return rs.wasNull() ? null : new ByteArrayBlob(blob);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 2004);
        } else {
            st.setBlob(index, (Blob)value);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        try {
            return ByteArrayBlob.create((Blob)value);
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return ((ByteArrayBlob)value)._bytes;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        return new ByteArrayBlob((byte[])cached);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

