/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.db;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.logging.Logger;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.db.HibernateUserImpl;
import org.jboss.portal.identity.service.UserModuleService;

public class HibernateUserModuleImpl
extends UserModuleService {
    private static final Logger log = Logger.getLogger(HibernateUserModuleImpl.class);
    protected SessionFactory sessionFactory;
    protected String sessionFactoryJNDIName;

    public void start() throws Exception {
        this.sessionFactory = (SessionFactory)new InitialContext().lookup(this.sessionFactoryJNDIName);
        super.start();
    }

    public void stop() throws Exception {
        this.sessionFactory = null;
        super.stop();
    }

    public String getSessionFactoryJNDIName() {
        return this.sessionFactoryJNDIName;
    }

    public void setSessionFactoryJNDIName(String sessionFactoryJNDIName) {
        this.sessionFactoryJNDIName = sessionFactoryJNDIName;
    }

    public User findUserByUserName(String userName) throws IdentityException {
        if (userName != null) {
            try {
                Session session = this.getCurrentSession();
                Query query = session.createQuery("from HibernateUserImpl where userName=:userName");
                query.setParameter("userName", (Object)userName);
                query.setCacheable(true);
                HibernateUserImpl user = (HibernateUserImpl)query.uniqueResult();
                if (user == null) {
                    throw new NoSuchUserException("No such user " + userName);
                }
                return user;
            }
            catch (HibernateException e) {
                String message = "Cannot find user by name " + userName;
                log.error((Object)message, (Throwable)e);
                throw new IdentityException(message, e);
            }
        }
        throw new IllegalArgumentException("user name cannot be null");
    }

    public User findUserById(String id) throws IllegalArgumentException, IdentityException, NoSuchUserException {
        if (id == null) {
            throw new IllegalArgumentException("The id is null");
        }
        try {
            return this.findUserById(new Long(id));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse id into an long " + id);
        }
    }

    public User findUserById(Object id) throws IllegalArgumentException, IdentityException, NoSuchUserException {
        if (id instanceof Long) {
            try {
                Session session = this.getCurrentSession();
                HibernateUserImpl user = (HibernateUserImpl)session.get(HibernateUserImpl.class, (Serializable)((Long)id));
                if (user == null) {
                    throw new NoSuchUserException("No user found for " + id);
                }
                return user;
            }
            catch (HibernateException e) {
                String message = "Cannot find user by id " + id;
                log.error((Object)message, (Throwable)e);
                throw new IdentityException(message, e);
            }
        }
        throw new IllegalArgumentException("The id is not an long : " + id);
    }

    public User createUser(String userName, String password) throws IdentityException {
        if (userName != null) {
            try {
                HibernateUserImpl user = new HibernateUserImpl(userName);
                user.updatePassword(password);
                Session session = this.getCurrentSession();
                session.save((Object)user);
                this.fireUserCreatedEvent(user.getId(), user.getUserName());
                return user;
            }
            catch (HibernateException e) {
                String message = "Cannot create user " + userName;
                log.error((Object)message, (Throwable)e);
                throw new IdentityException(message, e);
            }
        }
        throw new IllegalArgumentException("name cannot be null");
    }

    public void removeUser(Object id) throws IdentityException {
        if (id == null) {
            throw new IllegalArgumentException("User id cannot be null");
        }
        if (id instanceof Long) {
            try {
                Session session = this.getCurrentSession();
                HibernateUserImpl user = (HibernateUserImpl)session.load(HibernateUserImpl.class, (Serializable)id);
                if (user == null) {
                    throw new NoSuchUserException("No such user " + id);
                }
                String userName = user.getUserName();
                session.delete((Object)user);
                session.flush();
                this.fireUserDestroyedEvent(id, userName);
            }
            catch (HibernateException e) {
                String message = "Cannot remove user " + id;
                log.error((Object)message, (Throwable)e);
                throw new IdentityException(message, e);
            }
        } else {
            throw new IllegalArgumentException("The id is not an long : " + id);
        }
    }

    public Set findUsers(int offset, int limit) throws IdentityException {
        try {
            Session session = this.getCurrentSession();
            Query query = session.createQuery("from HibernateUserImpl as u order by u.userName");
            query.setFirstResult(offset);
            query.setMaxResults(limit);
            Iterator iterator = query.iterate();
            return Tools.toSet((Iterator)iterator, (boolean)true);
        }
        catch (HibernateException e) {
            String message = "Cannot find user range [" + offset + "," + limit + "]";
            log.error((Object)message, (Throwable)e);
            throw new IdentityException(message, e);
        }
    }

    public Set findUsersFilteredByUserName(String filter, int offset, int limit) throws IdentityException {
        try {
            filter = "%" + filter.replaceAll("%", "") + "%";
            Session session = this.getCurrentSession();
            Query query = session.createQuery("from HibernateUserImpl as u where u.userName like :filter order by u.userName");
            query.setString("filter", filter);
            query.setFirstResult(offset);
            query.setMaxResults(limit);
            Iterator iterator = query.iterate();
            return Tools.toSet((Iterator)iterator, (boolean)true);
        }
        catch (HibernateException e) {
            String message = "Cannot find user range [" + offset + "," + limit + "]";
            log.error((Object)message, (Throwable)e);
            throw new IdentityException(message, e);
        }
    }

    public int getUserCount() throws IdentityException {
        try {
            Session session = this.getCurrentSession();
            Query query = session.createQuery("select count(u.key) from HibernateUserImpl as u");
            return ((Number)query.uniqueResult()).intValue();
        }
        catch (HibernateException e) {
            String message = "Cannot count users";
            log.error((Object)message, (Throwable)e);
            throw new IdentityException(message, e);
        }
    }

    protected Session getCurrentSession() throws IllegalStateException {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("No session factory");
        }
        return this.sessionFactory.getCurrentSession();
    }
}

