/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.jboss.logging.Logger;
import org.jboss.security.CertificatePrincipal;
import org.jboss.security.RealmMapping;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.security.auth.callback.CallbackHandlerPolicyContextHandler;
import org.jboss.security.auth.certs.SubjectDNMapping;
import org.jboss.web.tomcat.security.DigestCallbackHandler;
import org.jboss.web.tomcat.security.JBossGenericPrincipal;
import org.jboss.web.tomcat.security.SecurityAssociationActions;
import org.jboss.web.tomcat.security.SecurityAssociationValve;

public class JBossSecurityMgrRealm
extends RealmBase
implements Realm {
    static Logger log = Logger.getLogger(JBossSecurityMgrRealm.class);
    private CertificatePrincipal certMapping = new SubjectDNMapping();
    private boolean trace;
    private RealmBase.AllRolesMode allRolesMode = RealmBase.AllRolesMode.AUTH_ONLY_MODE;

    public void setCertificatePrincipal(String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cpClass = loader.loadClass(className);
            this.certMapping = (CertificatePrincipal)cpClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Failed to load CertificatePrincipal: " + className), (Throwable)e);
            this.certMapping = new SubjectDNMapping();
        }
    }

    private javax.naming.Context getSecurityContext() {
        javax.naming.Context securityCtx = null;
        try {
            InitialContext iniCtx = new InitialContext();
            securityCtx = (javax.naming.Context)iniCtx.lookup("java:comp/env/security");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return securityCtx;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        super.start();
        this.trace = log.isTraceEnabled();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        super.stop();
    }

    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] constraints, Context context) throws IOException {
        String[] roles;
        SecurityConstraint constraint;
        int i;
        if (constraints == null || constraints.length == 0) {
            return true;
        }
        boolean hasPermission = false;
        LoginConfig config = context.getLoginConfig();
        if (config != null && "FORM".equals(config.getAuthMethod())) {
            String requestURI = request.getRequestPathMB().toString();
            String loginPage = config.getLoginPage();
            if (loginPage.equals(requestURI)) {
                if (this.trace) {
                    log.trace((Object)("Allow access to login page " + loginPage));
                }
                return true;
            }
            String errorPage = config.getErrorPage();
            if (errorPage.equals(requestURI)) {
                if (this.trace) {
                    log.trace((Object)("Allow access to error page " + errorPage));
                }
                return true;
            }
            if (requestURI.endsWith("/j_security_check")) {
                if (this.trace) {
                    log.trace((Object)"Allow access to username/password submission");
                }
                return true;
            }
        }
        Principal principal = request.getPrincipal();
        boolean denyfromall = false;
        for (i = 0; i < constraints.length; ++i) {
            constraint = constraints[i];
            roles = constraint.getAllRoles() ? request.getContext().findSecurityRoles() : constraint.findAuthRoles();
            if (roles == null) {
                roles = new String[]{};
            }
            if (this.trace) {
                log.trace((Object)("Checking roles " + principal));
            }
            if (roles.length == 0 && !constraint.getAllRoles()) {
                if (constraint.getAuthConstraint()) {
                    if (this.trace) {
                        log.trace((Object)"No roles");
                    }
                    hasPermission = false;
                    denyfromall = true;
                    continue;
                }
                if (this.trace) {
                    log.trace((Object)"Passing all access");
                }
                return true;
            }
            if (principal == null) {
                if (this.trace) {
                    log.trace((Object)"No user authenticated, cannot grant access");
                }
                hasPermission = false;
                continue;
            }
            if (denyfromall) continue;
            for (int j = 0; j < roles.length; ++j) {
                if (this.hasRole(principal, roles[j])) {
                    hasPermission = true;
                }
                if (!this.trace) continue;
                log.trace((Object)("No role found:  " + roles[j]));
            }
        }
        if (this.allRolesMode != RealmBase.AllRolesMode.STRICT_MODE && !hasPermission && principal != null) {
            if (this.trace) {
                log.trace((Object)("Checking for all roles mode: " + this.allRolesMode));
            }
            for (i = 0; i < constraints.length; ++i) {
                constraint = constraints[i];
                if (!constraint.getAllRoles()) continue;
                if (this.allRolesMode == RealmBase.AllRolesMode.AUTH_ONLY_MODE) {
                    if (this.trace) {
                        log.trace((Object)"Granting access for role-name=*, auth-only");
                    }
                    hasPermission = true;
                    break;
                }
                roles = request.getContext().findSecurityRoles();
                if (roles.length != 0 || this.allRolesMode != RealmBase.AllRolesMode.STRICT_AUTH_ONLY_MODE) continue;
                if (this.trace) {
                    log.trace((Object)"Granting access for role-name=*, strict auth-only");
                }
                hasPermission = true;
                break;
            }
        }
        if (!hasPermission) {
            response.sendError(403, sm.getString("realmBase.forbidden"));
        }
        return hasPermission;
    }

    public Principal authenticate(X509Certificate[] certs) {
        Principal principal = null;
        javax.naming.Context securityCtx = this.getSecurityContext();
        if (securityCtx == null) {
            if (this.trace) {
                log.trace((Object)"No security context for authenticate(X509Certificate[])");
            }
            return null;
        }
        try {
            SubjectSecurityManager securityMgr = (SubjectSecurityManager)securityCtx.lookup("securityMgr");
            Subject subject = new Subject();
            principal = this.certMapping.toPrinicipal(certs);
            if (securityMgr.isValid(principal, (Object)certs, subject)) {
                if (this.trace) {
                    log.trace((Object)("User: " + principal + " is authenticated"));
                }
                SecurityAssociationActions.setPrincipalInfo(principal, certs, subject);
                RealmMapping realmMapping = (RealmMapping)securityCtx.lookup("realmMapping");
                Principal oldPrincipal = principal;
                principal = realmMapping.getPrincipal(oldPrincipal);
                if (this.trace) {
                    log.trace((Object)("Mapped from input principal: " + oldPrincipal + "to: " + principal));
                }
                principal = this.getCachingPrincpal(realmMapping, oldPrincipal, principal, certs, subject);
            } else {
                if (this.trace) {
                    log.trace((Object)("User: " + principal + " is NOT authenticated"));
                }
                principal = null;
            }
        }
        catch (NamingException e) {
            log.error((Object)"Error during authenticate", (Throwable)e);
        }
        return principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(String username, String digest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        Object principal = null;
        javax.naming.Context securityCtx = this.getSecurityContext();
        if (securityCtx == null) {
            if (this.trace) {
                log.trace((Object)"No security context for authenticate(String, String)");
            }
            return null;
        }
        Principal caller = (Principal)SecurityAssociationValve.userPrincipal.get();
        if (caller == null && username == null && digest == null) {
            return null;
        }
        try {
            DigestCallbackHandler handler = new DigestCallbackHandler(username, nonce, nc, cnonce, qop, realm, md5a2);
            CallbackHandlerPolicyContextHandler.setCallbackHandler((CallbackHandler)handler);
            SubjectSecurityManager securityMgr = (SubjectSecurityManager)securityCtx.lookup("securityMgr");
            principal = new SimplePrincipal(username);
            Subject subject = new Subject();
            if (securityMgr.isValid((Principal)principal, (Object)digest, subject)) {
                log.trace((Object)("User: " + username + " is authenticated"));
                SecurityAssociationActions.setPrincipalInfo((Principal)principal, digest, subject);
                RealmMapping realmMapping = (RealmMapping)securityCtx.lookup("realmMapping");
                SimplePrincipal oldPrincipal = principal;
                principal = realmMapping.getPrincipal((Principal)oldPrincipal);
                if (this.trace) {
                    log.trace((Object)("Mapped from input principal: " + oldPrincipal + "to: " + principal));
                }
                principal = this.getCachingPrincpal(realmMapping, (Principal)oldPrincipal, (Principal)principal, digest, subject);
            } else {
                principal = null;
                if (this.trace) {
                    log.trace((Object)("User: " + username + " is NOT authenticated"));
                }
            }
        }
        catch (NamingException e) {
            principal = null;
            log.error((Object)"Error during authenticate", (Throwable)e);
        }
        finally {
            CallbackHandlerPolicyContextHandler.setCallbackHandler(null);
        }
        if (this.trace) {
            log.trace((Object)("End authenticate, principal=" + principal));
        }
        return principal;
    }

    public Principal authenticate(String username, String credentials) {
        if (this.trace) {
            log.trace((Object)("Begin authenticate, username=" + username));
        }
        Object principal = null;
        javax.naming.Context securityCtx = this.getSecurityContext();
        if (securityCtx == null) {
            if (this.trace) {
                log.trace((Object)"No security context for authenticate(String, String)");
            }
            return null;
        }
        Principal caller = (Principal)SecurityAssociationValve.userPrincipal.get();
        if (caller == null && username == null && credentials == null) {
            return null;
        }
        try {
            SubjectSecurityManager securityMgr = (SubjectSecurityManager)securityCtx.lookup("securityMgr");
            principal = new SimplePrincipal(username);
            Subject subject = new Subject();
            if (securityMgr.isValid((Principal)principal, (Object)credentials, subject)) {
                log.trace((Object)("User: " + username + " is authenticated"));
                SecurityAssociationActions.setPrincipalInfo((Principal)principal, credentials, subject);
                RealmMapping realmMapping = (RealmMapping)securityCtx.lookup("realmMapping");
                SimplePrincipal oldPrincipal = principal;
                principal = realmMapping.getPrincipal((Principal)oldPrincipal);
                if (this.trace) {
                    log.trace((Object)("Mapped from input principal: " + oldPrincipal + "to: " + principal));
                }
                principal = this.getCachingPrincpal(realmMapping, (Principal)oldPrincipal, (Principal)principal, credentials, subject);
            } else {
                principal = null;
                if (this.trace) {
                    log.trace((Object)("User: " + username + " is NOT authenticated"));
                }
            }
        }
        catch (NamingException e) {
            principal = null;
            log.error((Object)"Error during authenticate", (Throwable)e);
        }
        if (this.trace) {
            log.trace((Object)("End authenticate, principal=" + principal));
        }
        return principal;
    }

    public boolean hasRole(Principal principal, String role) {
        return super.hasRole(principal, role);
    }

    public Principal authenticate(String username, byte[] credentials) {
        return this.authenticate(username, new String(credentials));
    }

    protected String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getPassword(String username) {
        String password = null;
        return password;
    }

    protected Principal getPrincipal(String username) {
        return new SimplePrincipal(username);
    }

    protected Set getPrincipalRoles(Principal principal) {
        if (!(principal instanceof GenericPrincipal)) {
            throw new IllegalStateException("Expected GenericPrincipal, but saw: " + principal.getClass());
        }
        GenericPrincipal gp = (GenericPrincipal)principal;
        String[] roleNames = gp.getRoles();
        HashSet<SimplePrincipal> userRoles = new HashSet<SimplePrincipal>();
        if (roleNames != null) {
            for (int n = 0; n < roleNames.length; ++n) {
                SimplePrincipal sp = new SimplePrincipal(roleNames[n]);
                userRoles.add(sp);
            }
        }
        return userRoles;
    }

    protected Principal getCachingPrincpal(RealmMapping realmMapping, Principal authPrincipal, Principal callerPrincipal, Object credential, Subject subject) {
        Set userRoles = realmMapping.getUserRoles(authPrincipal);
        ArrayList<String> roles = new ArrayList<String>();
        if (userRoles != null) {
            for (Principal role : userRoles) {
                roles.add(role.getName());
            }
        }
        JBossGenericPrincipal gp = new JBossGenericPrincipal(this, subject, authPrincipal, callerPrincipal, credential, roles, userRoles);
        return gp;
    }
}

