/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.widget.google.provider;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.jboss.logging.Logger;
import org.jboss.portal.common.text.FastURLEncoder;
import org.jboss.portal.widget.WidgetQuery;

public final class GGQuery
implements WidgetQuery {
    private static final Logger log = Logger.getLogger(GGQuery.class);
    private int start;
    private int num = 24;
    private String cat;
    private String q;
    private int hashCode;
    private Locale locale;

    public GGQuery(int start, String cat, String q, Locale locale) {
        if (start < 0) {
            throw new IllegalArgumentException("No negative start");
        }
        if (cat != null && cat.length() == 0) {
            cat = null;
        }
        if (q != null && q.length() == 0) {
            q = null;
        }
        this.start = start;
        this.num = 10;
        this.cat = cat;
        this.q = q;
        this.locale = locale;
        this.hashCode = start + 10 + (cat == null ? 0 : 1 + cat.hashCode()) + (q == null ? 0 : 1 + q.hashCode()) + (locale == null ? 0 : 1 + locale.hashCode());
    }

    public GGQuery(int start, int num, String cat, String q, Locale locale) {
        this(start, cat, q, locale);
        if (num < 1) {
            throw new IllegalArgumentException("No zero or negative num.");
        }
        this.num = num;
        this.hashCode = start + num + (cat == null ? 0 : 1 + cat.hashCode()) + (q == null ? 0 : 1 + q.hashCode()) + (locale == null ? 0 : 1 + locale.hashCode());
    }

    public int getStart() {
        return this.start;
    }

    public int getNum() {
        return this.num;
    }

    public String getCat() {
        return this.cat;
    }

    public String getQ() {
        return this.q;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GGQuery) {
            GGQuery that = (GGQuery)obj;
            return this.start == that.start && this.num == that.num && (this.cat == null ? that.cat == null : this.cat.equals(that.cat)) && (this.q == null ? that.q == null : this.q.equals(that.q));
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public URL buildQueryURL() throws MalformedURLException {
        StringBuffer buffer = new StringBuffer("http://www.google.com/ig/directory?synd=jboss&output=rss");
        if (this.start > 0) {
            buffer.append("&start=").append(this.start);
        }
        if (this.num > 0) {
            buffer.append("&num=").append(this.num);
        }
        if (this.cat != null) {
            buffer.append("&cat=").append(this.cat);
        }
        if (this.q != null) {
            buffer.append("&q=").append(FastURLEncoder.getUTF8Instance().encode(this.q));
        }
        if (this.locale != null && this.locale.getLanguage().length() > 0) {
            buffer.append("&lang=").append(this.locale.getLanguage());
        }
        if (this.locale != null && this.locale.getCountry().length() > 0) {
            buffer.append("&country=").append(this.locale.getCountry());
        } else if (this.locale != null && this.locale.getLanguage().length() > 0) {
            buffer.append("&country=").append(this.locale.getLanguage());
        }
        log.debug((Object)("Google Gadgets Directory query URL: " + buffer.toString()));
        return new URL(buffer.toString());
    }
}

