/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.deployment.jboss;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.management.MBeanServer;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.jboss.portal.server.deployment.jboss.Deployment;
import org.jboss.portal.theme.RuntimeContext;
import org.jboss.portal.theme.ThemeException;
import org.jboss.portal.theme.deployment.jboss.PortalThemeMetaDataFactory;
import org.jboss.portal.theme.deployment.jboss.ThemeDeploymentFactory;
import org.jboss.portal.theme.metadata.PortalThemeMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallerFactory;

public class ThemeDeployment
extends Deployment {
    private final ThemeDeploymentFactory factory;
    private static Logger log = Logger.getLogger(ThemeDeployment.class);

    public ThemeDeployment(URL url, PortalWebApp pwa, MBeanServer mbeanServer, ThemeDeploymentFactory factory) {
        super(url, pwa, mbeanServer);
        this.factory = factory;
    }

    public void create() throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("create new theme(s), found in :  " + this.pwa.getId()));
        }
        BufferedInputStream themeStream = null;
        try {
            themeStream = IOTools.safeBufferedWrapper((InputStream)this.url.openStream());
            RuntimeContext ctx = new RuntimeContext(this.pwa.getId(), this.pwa.getServletContext(), this.pwa.getContextPath(), this.pwa.getClassLoader());
            List portalThemes = (List)UnmarshallerFactory.newInstance().newUnmarshaller().unmarshal((InputStream)themeStream, (ObjectModelFactory)new PortalThemeMetaDataFactory(), null);
            for (PortalThemeMetaData themeMD : portalThemes) {
                this.factory.getThemeService().addTheme(ctx, themeMD);
            }
        }
        catch (Exception e) {
            try {
                throw new DeploymentException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOTools.safeClose(themeStream);
                throw throwable;
            }
        }
        IOTools.safeClose((Closeable)themeStream);
    }

    public void destroy() throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("destroying theme(s), found in :  " + this.pwa.getId()));
        }
        try {
            this.factory.getThemeService().removeThemes(this.pwa.getId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("done destroying theme(s), found in :  " + this.pwa.getId()));
            }
        }
        catch (ThemeException e) {
            throw new DeploymentException((Throwable)e);
        }
    }
}

