/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jgroups.blocks.MethodCall;

public class OptimisticLockingInterceptor
extends OptimisticInterceptor {
    private long lockAcquisitionTimeout;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.lockAcquisitionTimeout = cache.getLockAcquisitionTimeout();
    }

    public Object invoke(MethodCall call) throws Throwable {
        JBCMethodCall m = (JBCMethodCall)call;
        InvocationContext ctx = this.getInvocationContext();
        Object retval = null;
        Method meth = m.getMethod();
        if (this.isBuddyGroupOrganisationMethod(m)) {
            return super.invoke(m);
        }
        if (m.getMethodId() == 33) {
            this.log.warn((Object)"OptimisticLockingInterceptor intercepted a call to TreeCache._lock().  This should NEVER be called if optimistic locking is used!!  Not allowing this call to proceed further down the chain.");
            return retval;
        }
        if (ctx.getTransaction() != null) {
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            if (gtx == null) {
                throw new Exception("failed to get global transaction");
            }
            switch (m.getMethodId()) {
                case 18: {
                    try {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Calling lockNodes() with gtx " + ctx.getGlobalTransaction()));
                        }
                        this.lockNodes(gtx);
                    }
                    catch (Throwable e) {
                        this.log.debug((Object)"Caught exception attempting to lock nodes ", e);
                        try {
                            this.unlock(gtx);
                        }
                        catch (Throwable t) {
                            this.log.fatal((Object)"Failed to unlock on prepare ", t);
                        }
                        throw e;
                    }
                    retval = super.invoke(m);
                    break;
                }
                case 11: 
                case 12: {
                    try {
                        retval = super.invoke(m);
                        this.unlock(gtx);
                        break;
                    }
                    catch (Throwable t) {
                        this.log.debug((Object)("exception encountered on " + meth + " running unlock "), t);
                        try {
                            this.unlock(gtx);
                        }
                        catch (Throwable ct) {
                            this.log.fatal((Object)("Failed to unlock on " + meth), t);
                        }
                        throw t;
                    }
                }
                default: {
                    retval = super.invoke(m);
                    break;
                }
            }
        } else {
            throw new CacheException("not in a transaction");
        }
        return retval;
    }

    private void lockNodes(GlobalTransaction gtx) throws Exception {
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        TransactionEntry te = this.cache.getTransactionTable().get(gtx);
        this.log.debug((Object)"locking nodes");
        Collection nodes = workspace.getNodes().values();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            boolean writeLock;
            WorkspaceNode workspaceNode = (WorkspaceNode)it.next();
            DataNode node = workspaceNode.getNode();
            boolean acquired = node.acquire(gtx, this.lockAcquisitionTimeout, (writeLock = workspaceNode.isDirty() || workspaceNode.isCreated() || workspaceNode.isDeleted() || workspaceNode.isChildrenModified() && this.cache.getLockParentForChildInsertRemove()) ? 2 : 1);
            if (acquired) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("acquired lock on node " + node.getName()));
                }
                te.addLock(node.getLock());
                continue;
            }
            throw new CacheException("unable to acquire lock on node " + node.getName());
        }
    }

    private void unlock(GlobalTransaction gtx) {
        TransactionEntry entry = this.txTable.get(gtx);
        entry.releaseAllLocksFIFO(gtx);
    }
}

