/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.domain;

import org.apache.commons.lang.StringUtils;

public class Symlink {
    private final String parentPath;
    private final String segment;
    private final String targetPath;
    private final String targetWebId;
    private final String virtualPath;

    public Symlink(String parentPath, String segment, String targetPath, String targetWebId) {
        this.parentPath = StringUtils.removeEnd((String)parentPath, (String)".proxy");
        this.segment = segment;
        this.targetPath = targetPath;
        this.targetWebId = targetWebId;
        this.virtualPath = this.parentPath + "/symlink_" + segment;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Symlink [parentPath=");
        builder.append(this.parentPath);
        builder.append(", segment=");
        builder.append(this.segment);
        builder.append(", targetPath=");
        builder.append(this.targetPath);
        builder.append(", targetWebId=");
        builder.append(this.targetWebId);
        builder.append("]");
        return builder.toString();
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getSegment() {
        return this.segment;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public String getTargetWebId() {
        return this.targetWebId;
    }

    public String getVirtualPath() {
        return this.virtualPath;
    }
}

