/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.deployment.jboss;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.transaction.TransactionManager;
import org.jboss.deployment.DeploymentException;
import org.jboss.portal.common.transaction.TransactionManagerProvider;
import org.jboss.portal.core.controller.coordination.CoordinationConfigurator;
import org.jboss.portal.core.deployment.jboss.ObjectDeployment;
import org.jboss.portal.core.model.content.spi.ContentProviderRegistry;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.jboss.portal.server.deployment.jboss.AbstractDeploymentFactory;
import org.jboss.portal.server.deployment.jboss.Deployment;
import org.xml.sax.EntityResolver;

public class ObjectDeploymentFactory
extends AbstractDeploymentFactory {
    protected static final Pattern URL_PATTERN = Pattern.compile(".*-object\\.xml");
    protected URL setupURL;
    protected PortalObjectContainer portalObjectContainer;
    protected ContentProviderRegistry contentProviderRegistry;
    protected EntityResolver portalObjectEntityResolver;
    protected CoordinationConfigurator coordinationConfigurator;

    public boolean acceptFile(URL url) {
        String urlAsFile = url.getFile();
        Matcher matcher = URL_PATTERN.matcher(urlAsFile);
        return matcher.matches();
    }

    public Deployment newInstance(URL url, PortalWebApp pwa, MBeanServer mbeanServer) throws DeploymentException {
        try {
            TransactionManager tm = TransactionManagerProvider.JBOSS_PROVIDER.getTransactionManager();
            return new ObjectDeployment(url, mbeanServer, tm, pwa, this);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public EntityResolver getPortalObjectEntityResolver() {
        return this.portalObjectEntityResolver;
    }

    public void setPortalObjectEntityResolver(EntityResolver portalObjectEntityResolver) {
        this.portalObjectEntityResolver = portalObjectEntityResolver;
    }

    public PortalObjectContainer getPortalObjectContainer() {
        return this.portalObjectContainer;
    }

    public void setPortalObjectContainer(PortalObjectContainer portalObjectContainer) {
        this.portalObjectContainer = portalObjectContainer;
    }

    public ContentProviderRegistry getContentProviderRegistry() {
        return this.contentProviderRegistry;
    }

    public void setContentProviderRegistry(ContentProviderRegistry contentProviderRegistry) {
        this.contentProviderRegistry = contentProviderRegistry;
    }

    public CoordinationConfigurator getCoordinationConfigurator() {
        return this.coordinationConfigurator;
    }

    public void setCoordinationConfigurator(CoordinationConfigurator coordinationConfigurator) {
        this.coordinationConfigurator = coordinationConfigurator;
    }
}

