/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui.actions;

import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.core.admin.ui.PortalObjectManagerBean;
import org.jboss.portal.core.impl.model.portal.PortalObjectImpl;
import org.jboss.portal.faces.gui.ManagedBean;

public class PropertyAction
extends ManagedBean {
    private PortalObjectManagerBean pomgr;
    private String selectedProperty;
    private String propertyValue;
    private String otherPropertyName;
    protected static final String PROPERTY_TYPE = "PROPERTY_TYPE";

    public PropertyAction(PortalObjectManagerBean pomgr) {
        this.pomgr = pomgr;
    }

    public String getSelectedProperty() {
        return this.selectedProperty;
    }

    public void setSelectedProperty(String selectedProperty) {
        this.selectedProperty = selectedProperty;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    public void selectProperty() {
    }

    public void removeProperty() {
        String name = this.beanContext.getParameter("name");
        ((PortalObjectImpl)this.pomgr.getSelectedObject()).setDeclaredProperty(name, null);
    }

    public void updateProperty() {
        String propertyName = "";
        if (!ParameterValidation.isNullOrEmpty((String)this.otherPropertyName)) {
            propertyName = this.checkNameValidity(this.otherPropertyName, "common-edit-prop-form:property");
        }
        if (propertyName != null) {
            if (propertyName.length() == 0 && this.selectedProperty != null) {
                propertyName = this.selectedProperty.trim();
            }
            if (propertyName.length() > 0) {
                String value = "";
                if (this.getPropertyValue() != null) {
                    value = this.getPropertyValue().trim();
                }
                this.pomgr.getSelectedObject().setDeclaredProperty(propertyName, value);
            }
        }
    }

    public String getOtherPropertyName() {
        return this.otherPropertyName;
    }

    public void setOtherPropertyName(String otherPropertyName) {
        this.otherPropertyName = otherPropertyName;
    }

    protected String getObjectTypeName() {
        return PROPERTY_TYPE;
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.pomgr.getSelectedObject().getDeclaredProperty(objectName) != null;
    }
}

