/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.ldap;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.jboss.logging.Logger;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.ldap.LDAPUserImpl;
import org.jboss.portal.identity.ldap.LDAPUserModule;
import org.jboss.portal.identity.ldap.helper.LDAPTools;

public class LDAPUserModuleImpl
extends LDAPUserModule {
    private static final Logger log = Logger.getLogger(LDAPUserModuleImpl.class);

    public User findUserByUserName(String userName) throws IdentityException, IllegalArgumentException, NoSuchUserException {
        Context ctx = null;
        try {
            log.debug((Object)("findUserByUserName(): username = " + userName));
            if (userName == null) {
                throw new IdentityException("User name canot be null");
            }
            String filter = "(".concat(this.getUidAttributeID()).concat("=").concat(userName).concat(")");
            log.debug((Object)("Search filter: " + filter));
            List sr = this.searchUsers(filter, null);
            if (sr.size() > 1) {
                throw new IdentityException("Found more than one user with id: " + userName + "" + "Posible data inconsistency");
            }
            SearchResult res = (SearchResult)sr.iterator().next();
            ctx = (Context)res.getObject();
            String dn = ctx.getNameInNamespace();
            LDAPUserImpl user = this.createUserInstance(res.getAttributes(), dn);
            ctx.close();
            LDAPUserImpl lDAPUserImpl = user;
            return lDAPUserImpl;
        }
        catch (NoSuchElementException e) {
            log.debug((Object)("No user found with name: " + userName), (Throwable)e);
        }
        catch (NamingException e) {
            throw new IdentityException("User search failed.", e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        throw new NoSuchUserException("No user found with name: " + userName);
    }

    public User findUserById(Object id) throws IdentityException, IllegalArgumentException, NoSuchUserException {
        if (id == null) {
            throw new IdentityException("Cannot search user with null id");
        }
        if (!(id instanceof String)) {
            throw new IdentityException("Only String id is suppoted");
        }
        return this.findUserByDN(id.toString());
    }

    public User findUserById(String id) throws IdentityException, IllegalArgumentException, NoSuchUserException {
        return this.findUserByDN(id);
    }

    public User createUser(String userName, String password) throws IdentityException, IllegalArgumentException {
        if (userName == null) {
            throw new IdentityException("User name cannot be null");
        }
        if (password == null) {
            throw new IdentityException("User password cannot be null");
        }
        log.debug((Object)("Creating user: " + userName));
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            LdapContext ctx = (LdapContext)ldapContext.lookup(this.getContainerDN());
            BasicAttributes attrs = new BasicAttributes(true);
            Map attributesToAdd = this.getAttributesToAdd();
            for (String attributeName : attributesToAdd.keySet()) {
                if (this.getUidAttributeID().equals(attributeName)) continue;
                log.debug((Object)("adding attribute: " + attributeName));
                BasicAttribute attr = new BasicAttribute(attributeName);
                Set attributeValues = (Set)attributesToAdd.get(attributeName);
                for (String attrValue : attributeValues) {
                    log.debug((Object)("adding attribute value: " + attrValue));
                    attr.add(attrValue);
                }
                attrs.put(attr);
            }
            if (!this.isSetPasswordAfterUserCreate()) {
                attrs.put(this.getPasswordAttributeId(), password);
            }
            String validUserName = LDAPTools.encodeRfc2253Name(userName);
            String dn = this.getUidAttributeID().concat("=").concat(validUserName);
            log.debug((Object)("creating ldap entry for: " + dn + "; " + attrs));
            ctx.createSubcontext(dn, (Attributes)attrs);
        }
        catch (Exception e) {
            throw new IdentityException("Failed to create user", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        LDAPUserImpl u = (LDAPUserImpl)this.findUserByUserName(userName);
        if (this.isSetPasswordAfterUserCreate()) {
            this.updatePassword(u, password);
        }
        this.fireUserCreatedEvent(u.getId(), u.getUserName());
        return u;
    }

    public void removeUser(Object id) throws IdentityException, IllegalArgumentException {
        LDAPUserImpl ldapu = (LDAPUserImpl)this.findUserById(id);
        String userName = ldapu.getUserName();
        if (ldapu == null) {
            throw new IdentityException("Cannot find user for removal");
        }
        if (ldapu.getDn() == null) {
            throw new IdentityException("Cannot obtain DN of user");
        }
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            log.debug((Object)("removing entry: " + ldapu.getDn()));
            ldapContext.unbind(ldapu.getDn());
        }
        catch (Exception e) {
            throw new IdentityException("Failed to remove user: ", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        this.fireUserDestroyedEvent(id, userName);
    }

    public Set findUsers(int offset, int limit) throws IdentityException, IllegalArgumentException {
        return this.findUsersFilteredByUserName("*", offset, limit);
    }

    public Set findUsersFilteredByUserName(String filter, int offset, int limit) throws IdentityException, IllegalArgumentException {
        if (filter == null) {
            throw new IllegalArgumentException("Null user name filter");
        }
        if (limit == 0) {
            throw new IdentityException("Search limit shouldn't be set to 0");
        }
        List uf = new LinkedList();
        Object results = null;
        if (filter.length() == 0) {
            filter = "*";
        } else if (filter.length() != 1 || !filter.equals("*")) {
            filter = "*" + filter + "*";
        }
        try {
            String ldap_filter = "(".concat(this.getUidAttributeID()).concat("=").concat(filter).concat(")");
            log.debug((Object)("Search filter: " + filter));
            uf = this.searchUsers(ldap_filter, null);
            int size = uf.size();
            if (offset == 0 && size <= limit) {
                return this.processUsers(uf);
            }
            Collections.sort(uf, new UserEntryComparator());
            if (offset + limit <= size) {
                return this.processUsers(uf.subList(offset, offset + limit));
            }
            if (offset >= size) {
                return new HashSet();
            }
            return this.processUsers(uf.subList(offset, size));
        }
        catch (NoSuchElementException e) {
            log.debug((Object)"No users found", (Throwable)e);
        }
        catch (Throwable e) {
            throw new IdentityException("User search failed.", e);
        }
        return null;
    }

    public int getUserCount() throws IdentityException, IllegalArgumentException {
        try {
            String filter = "(".concat(this.getUidAttributeID()).concat("=").concat("*").concat(")");
            log.debug((Object)("Search filter: " + filter));
            List sr = this.searchUsers(filter, null);
            return sr.size();
        }
        catch (NoSuchElementException e) {
            log.debug((Object)"No users found", (Throwable)e);
        }
        catch (Exception e) {
            throw new IdentityException("User search failed.", e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List searchUsers(String filter, Object[] filterArgs) throws NamingException, IdentityException {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(1);
        controls.setReturningObjFlag(true);
        controls.setTimeLimit(this.getSearchTimeLimit());
        log.debug((Object)("Search filter: " + filter));
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        NamingEnumeration<SearchResult> results = null;
        try {
            if (filterArgs == null) {
                results = ldapContext.search(this.getContainerDN(), filter, controls);
                List list = Tools.toList(results);
                return list;
            }
            results = ldapContext.search(this.getContainerDN(), filter, filterArgs, controls);
            List list = Tools.toList(results);
            return list;
        }
        finally {
            if (results != null) {
                results.close();
            }
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    protected Set processUsers(Collection users) throws Exception {
        HashSet<LDAPUserImpl> ui = new HashSet<LDAPUserImpl>();
        for (SearchResult res : users) {
            Context ctx = (Context)res.getObject();
            String dn = ctx.getNameInNamespace();
            ui.add(this.createUserInstance(res.getAttributes(), dn));
            ctx.close();
        }
        return ui;
    }

    protected class UserEntryComparator
    implements Comparator {
        protected UserEntryComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                SearchResult u1 = (SearchResult)o1;
                SearchResult u2 = (SearchResult)o2;
                Attribute uida1 = u1.getAttributes().get(LDAPUserModuleImpl.this.getUidAttributeID());
                Attribute uida2 = u2.getAttributes().get(LDAPUserModuleImpl.this.getUidAttributeID());
                String name1 = uida1.get().toString();
                String name2 = uida2.get().toString();
                return name1.compareToIgnoreCase(name2);
            }
            catch (Throwable throwable) {
                return 0;
            }
        }
    }
}

