/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.cms;

import java.util.ArrayList;
import java.util.List;
import org.osivia.portal.api.portlet.PortalGenericPortlet;

public class DocumentType
implements Cloneable {
    private final String name;
    private final boolean folderish;
    private final boolean navigable;
    private final boolean browsable;
    private final boolean movable;
    private final boolean ordered;
    private final boolean forcePortalContextualization;
    private final boolean supportsPortalForms;
    private final List<String> portalFormSubTypes;
    private final String defaultTemplate;
    private final String glyph;
    private final boolean isRootType;
    private final boolean liveEditable;
    private final ClassLoader customizedClassLoader;
    private Boolean editorialContent;
    private boolean isFile;

    public DocumentType(String name, boolean folderish, boolean navigable, boolean browsable, boolean ordered, boolean forcePortalContextualization, boolean supportsPortalForms, List<String> portalFormSubTypes, String defaultTemplate) {
        this(name, folderish, navigable, browsable, ordered, forcePortalContextualization, supportsPortalForms, portalFormSubTypes, defaultTemplate, null);
    }

    public DocumentType(String name, boolean folderish, boolean navigable, boolean browsable, boolean ordered, boolean forcePortalContextualization, boolean supportsPortalForms, List<String> portalFormSubTypes, String defaultTemplate, String glyph) {
        this(name, folderish, navigable, browsable, ordered, forcePortalContextualization, supportsPortalForms, portalFormSubTypes, defaultTemplate, glyph, false, true);
    }

    public DocumentType(String name, boolean folderish, boolean navigable, boolean browsable, boolean ordered, boolean forcePortalContextualization, boolean supportsPortalForms, List<String> portalFormSubTypes, String defaultTemplate, String glyph, boolean isRootType) {
        this(name, folderish, navigable, browsable, ordered, forcePortalContextualization, supportsPortalForms, portalFormSubTypes, defaultTemplate, glyph, isRootType, true);
    }

    public DocumentType(String name, boolean folderish, boolean navigable, boolean browsable, boolean ordered, boolean forcePortalContextualization, boolean supportsPortalForms, List<String> portalFormSubTypes, String defaultTemplate, String glyph, boolean isRootType, boolean movable) {
        this(name, folderish, navigable, browsable, ordered, forcePortalContextualization, supportsPortalForms, portalFormSubTypes, defaultTemplate, glyph, isRootType, movable, false);
    }

    public DocumentType(String name, boolean folderish, boolean navigable, boolean browsable, boolean ordered, boolean forcePortalContextualization, boolean supportsPortalForms, List<String> portalFormSubTypes, String defaultTemplate, String glyph, boolean isRootType, boolean movable, boolean liveEditable) {
        this.name = name;
        this.folderish = folderish;
        this.navigable = navigable;
        this.browsable = browsable;
        this.ordered = ordered;
        this.forcePortalContextualization = forcePortalContextualization;
        this.supportsPortalForms = supportsPortalForms;
        this.portalFormSubTypes = portalFormSubTypes;
        this.defaultTemplate = defaultTemplate;
        this.glyph = glyph;
        this.isRootType = isRootType;
        this.movable = movable;
        this.liveEditable = liveEditable;
        this.customizedClassLoader = PortalGenericPortlet.CLASS_LOADER_CONTEXT.get();
    }

    public DocumentType clone() {
        ArrayList<String> subTypes = new ArrayList<String>(this.portalFormSubTypes);
        DocumentType clone = new DocumentType(this.name, this.folderish, this.navigable, this.browsable, this.ordered, this.forcePortalContextualization, this.supportsPortalForms, subTypes, this.defaultTemplate, this.glyph, this.isRootType, this.movable, this.liveEditable);
        clone.editorialContent = this.editorialContent;
        clone.isFile = this.isFile;
        return clone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentType other = (DocumentType)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DocumentType [name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public boolean isFolderish() {
        return this.folderish;
    }

    public boolean isNavigable() {
        return this.navigable;
    }

    public boolean isBrowsable() {
        return this.browsable;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isForcePortalContextualization() {
        return this.forcePortalContextualization;
    }

    public boolean isSupportsPortalForms() {
        return this.supportsPortalForms;
    }

    public List<String> getPortalFormSubTypes() {
        return this.portalFormSubTypes;
    }

    public String getDefaultTemplate() {
        return this.defaultTemplate;
    }

    public String getGlyph() {
        return this.glyph;
    }

    public boolean isRootType() {
        return this.isRootType;
    }

    public boolean isMovable() {
        return this.movable;
    }

    public boolean isLiveEditable() {
        return this.liveEditable;
    }

    public ClassLoader getCustomizedClassLoader() {
        return this.customizedClassLoader;
    }

    public Boolean getEditorialContent() {
        return this.editorialContent;
    }

    public void setEditorialContent(Boolean editorialContent) {
        this.editorialContent = editorialContent;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public void setFile(boolean isFile) {
        this.isFile = isFile;
    }
}

