/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.registration.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.registration.Consumer;
import org.jboss.portal.registration.Registration;
import org.jboss.portal.registration.RegistrationStatus;
import org.jboss.portal.registration.impl.ConsumerImpl;

public class RegistrationImpl
implements Registration {
    private final String id;
    private ConsumerImpl consumer;
    private RegistrationStatus status;
    private Map properties;
    private String registrationHandle;

    public RegistrationImpl(String id, ConsumerImpl consumer, RegistrationStatus status, Map properties) {
        this.id = id;
        this.consumer = consumer;
        this.status = status;
        this.properties = new HashMap(properties);
    }

    public String getId() {
        return this.id;
    }

    public void setRegistrationHandle(String handle) {
        this.registrationHandle = handle;
    }

    public String getRegistrationHandle() {
        return this.registrationHandle;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setPropertyValueFor(QName propertyName, Object value) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)value, (String)"Property value");
        Object oldValue = this.properties.get(propertyName);
        if (!value.equals(oldValue)) {
            this.properties.put(propertyName, value);
        }
    }

    public void setPropertyValueFor(String propertyName, Object value) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        this.setPropertyValueFor(new QName(propertyName), value);
    }

    public Object getPropertyValueFor(QName propertyName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        return this.properties.get(propertyName);
    }

    public Object getPropertyValueFor(String propertyName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        return this.getPropertyValueFor(new QName(propertyName));
    }

    public void removeProperty(QName propertyName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        this.properties.remove(propertyName);
    }

    public void removeProperty(String propertyName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        this.removeProperty(new QName(propertyName));
    }

    public boolean hasEqualProperties(Registration registration) {
        if (registration == null) {
            return false;
        }
        Map other = registration.getProperties();
        return this.hasEqualProperties(other);
    }

    public boolean hasEqualProperties(Map registrationProperties) {
        if (registrationProperties == null) {
            return false;
        }
        if (this.properties.size() != registrationProperties.size()) {
            return false;
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            QName name = (QName)entry.getKey();
            if (entry.getValue().equals(registrationProperties.get(name))) continue;
            return false;
        }
        return true;
    }

    public void setRegistrationPropertyValueFor(String propertyName, Object value) {
        this.setPropertyValueFor(new QName(propertyName), value);
    }

    public RegistrationStatus getStatus() {
        return this.status;
    }

    public void setStatus(RegistrationStatus status) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)status, (String)"RegistrationStatus");
        this.status = status;
    }

    public void clearAssociatedState() {
    }

    public void updateProperties(Map registrationProperties) {
        this.properties = new HashMap(registrationProperties);
    }
}

