/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.aspects;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.portal.common.invocation.Interceptor;
import org.jboss.portal.common.invocation.Invocation;
import org.jboss.portal.common.invocation.InvocationException;

public abstract class LockInterceptor
implements Interceptor {
    private Map map = new HashMap();
    private Lock mapLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalLock acquire(Object lockId) {
        this.mapLock.lock();
        try {
            InternalLock lock;
            if (this.map.containsKey(lockId)) {
                lock = (InternalLock)this.map.get(lockId);
            } else {
                lock = new InternalLock(lockId);
                this.map.put(lockId, lock);
            }
            lock.waiters++;
            InternalLock internalLock = lock;
            return internalLock;
        }
        finally {
            this.mapLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release(InternalLock internalLock) {
        this.mapLock.lock();
        try {
            if (--internalLock.waiters == 0) {
                this.map.remove(internalLock.id);
            }
        }
        finally {
            this.mapLock.unlock();
        }
    }

    protected abstract Object getLockId(Invocation var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Exception, InvocationException {
        Object lockId = this.getLockId(invocation);
        if (lockId != null) {
            InternalLock internalLock = this.acquire(lockId);
            try {
                Object object = internalLock.invoke(invocation);
                return object;
            }
            finally {
                this.release(internalLock);
            }
        }
        return invocation.invokeNext();
    }

    public static class InternalLock {
        private final Object id;
        private final Lock lock = new ReentrantLock();
        private int waiters = 0;

        public InternalLock(Object id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object invoke(Invocation invocation) throws Exception, InvocationException {
            this.lock.lock();
            try {
                Object object = invocation.invokeNext();
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

