/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.jems.as;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.mx.util.ObjectNameConverter;

public final class JMX {
    private static final Logger log = Logger.getLogger(JMX.class);
    public static Comparator OBJECT_NAME_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            ObjectName n1 = (ObjectName)o1;
            ObjectName n2 = (ObjectName)o2;
            return n1.getCanonicalName().compareTo(n2.getCanonicalName());
        }
    };

    public static ObjectName extend(ObjectName name, Properties keyProperties) {
        try {
            Hashtable<String, String> table = name.getKeyPropertyList();
            table.putAll(keyProperties);
            return ObjectNameConverter.convert((String)name.getDomain(), table);
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)"", (Throwable)e);
            throw new RuntimeException();
        }
    }

    public static void safeUnregister(MBeanServer server, ObjectName name) {
        if (server != null) {
            if (name != null) {
                try {
                    server.unregisterMBean(name);
                }
                catch (InstanceNotFoundException e) {
                    log.error((Object)("MBean " + name + " nto here"));
                }
                catch (MBeanRegistrationException e) {
                    log.error((Object)"MBean threw an exception during unregistration", (Throwable)e.getTargetException());
                }
            } else {
                log.error((Object)"Cannot unregister a null MBean");
            }
        } else {
            log.error((Object)"Cannot unregister with a null MBeanServer");
        }
    }

    public static Object getMBeanProxy(Class clazz, ObjectName name, MBeanServer server) {
        try {
            return MBeanProxy.get((Class)clazz, (ObjectName)name, (MBeanServer)server);
        }
        catch (MBeanProxyCreationException e) {
            String message = "Couldn't retrieve '" + name.getCanonicalName() + "' MBean with class " + clazz.getName();
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    public static Object getMBeanProxy(Class clazz, String name) {
        ObjectName objecName;
        try {
            objecName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("'" + name + "' is not a valid ObjectName");
        }
        MBeanServer server = MBeanServerLocator.locateJBoss();
        return JMX.getMBeanProxy(clazz, objecName, server);
    }

    public static boolean addNotificationListener(MBeanServer server, ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        try {
            server.addNotificationListener(name, listener, filter, handback);
            return true;
        }
        catch (InstanceNotFoundException e) {
            return false;
        }
    }

    public static boolean removeNotificationListener(MBeanServer server, ObjectName name, NotificationListener listener) {
        try {
            server.removeNotificationListener(name, listener);
            return true;
        }
        catch (InstanceNotFoundException e) {
            log.error((Object)"Cannot remove notification listener", (Throwable)e);
            return false;
        }
        catch (ListenerNotFoundException e) {
            log.error((Object)"Cannot remove notification listener", (Throwable)e);
            return false;
        }
    }
}

