/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.tag;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.theme.Orientation;
import org.jboss.portal.theme.impl.JSPRendererContext;
import org.jboss.portal.theme.render.ObjectRendererContext;
import org.jboss.portal.theme.render.RenderException;
import org.jboss.portal.theme.render.renderer.PageRendererContext;
import org.jboss.portal.theme.render.renderer.RegionRendererContext;
import org.osivia.portal.api.panels.Panel;
import org.osivia.portal.core.theming.RegionDecorator;
import org.osivia.portal.core.theming.RegionRendererContextImpl;

public class RegionTagHandler
extends SimpleTagSupport {
    private static final Log log = LogFactory.getLog(RegionTagHandler.class);
    private String regionName;
    private String regionID;
    private Orientation orientation;
    private Boolean cms;

    public void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        Boolean layoutParsing = (Boolean)request.getAttribute("osivia.layout.parsing");
        if (BooleanUtils.isTrue((Boolean)layoutParsing)) {
            this.parseRegionAttributes(request);
        } else {
            this.renderRegion(request);
        }
    }

    private void parseRegionAttributes(HttpServletRequest request) {
        Set visibleRegions = (Set)request.getAttribute("osivia.layout.visibleRegions");
        visibleRegions.add(this.regionName);
        if (BooleanUtils.isTrue((Boolean)this.cms)) {
            request.setAttribute("osivia.layout.cms", (Object)true);
        }
        if (BooleanUtils.isNotTrue((Boolean)((Boolean)request.getAttribute("osivia.panels.display")))) {
            for (Panel panel : Panel.values()) {
                if (!panel.getRegionName().equals(this.regionName)) continue;
                request.setAttribute("osivia.panels.display", (Object)true);
                break;
            }
        }
    }

    private void renderRegion(HttpServletRequest request) throws JspException, IOException {
        if (this.regionID == null) {
            this.regionID = this.regionName;
        }
        log.debug((Object)("rendering " + this.regionName + " [" + this.orientation + "]  cssId[" + this.regionID + "]"));
        JspWriter out = this.getJspContext().getOut();
        PageRendererContext page = (PageRendererContext)request.getAttribute("PAGE");
        if (page == null) {
            out.write("<p bgcolor='red'>No page to render!</p>");
            out.write("<p bgcolor='red'>The page to render (PageResult) must be set in the request attribute 'PAGE'</p>");
            out.flush();
            return;
        }
        RegionRendererContext currentRegion = page.getRegion(this.regionName);
        RegionRendererContextImpl regionRendererContext = new RegionRendererContextImpl(currentRegion, this.regionName, this.regionID, this.cms, this.orientation);
        JSPRendererContext renderContext = (JSPRendererContext)request.getAttribute("RENDERCONTEXT");
        RegionDecorator decorator = null;
        Map decorators = (Map)request.getAttribute("osivia.regions.decorators");
        if (decorators != null) {
            decorator = (RegionDecorator)decorators.get(this.regionName);
        }
        renderContext.setAttribute("osivia.regions.decorators", decorator);
        try {
            PrintWriter writer = new PrintWriter((Writer)out);
            renderContext.setWriter(writer);
            renderContext.render((ObjectRendererContext)regionRendererContext);
            writer.flush();
        }
        catch (RenderException e) {
            throw new JspException((Throwable)e);
        }
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setRegionID(String regionID) {
        this.regionID = regionID;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public void setCms(Boolean cms) {
        this.cms = cms;
    }
}

