/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.metadata;

import org.jboss.logging.Logger;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.content.spi.ContentProviderRegistry;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.metadata.BuildContext;
import org.jboss.portal.core.model.portal.metadata.ContentMetaData;
import org.jboss.portal.core.model.portal.metadata.PortalObjectMetaData;
import org.w3c.dom.Element;

public class WindowMetaData
extends PortalObjectMetaData {
    private static final Logger logger = Logger.getLogger(WindowMetaData.class);
    protected String region;
    protected int order;
    protected String initialWindowState;
    protected String initialMode;
    protected ContentMetaData content;
    protected ContentType contentType;

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public ContentMetaData getContent() {
        return this.content;
    }

    public void setContent(ContentMetaData content) {
        this.content = content;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public String getInitialWindowState() {
        return this.initialWindowState;
    }

    public void setInitialWindowState(String initialWindowState) {
        this.initialWindowState = initialWindowState;
    }

    public String getInitialMode() {
        return this.initialMode;
    }

    public void setInitialMode(String initialMode) {
        this.initialMode = initialMode;
    }

    protected PortalObject newInstance(BuildContext buildContext, PortalObject parent) throws Exception {
        if (!(parent instanceof Page)) {
            throw new IllegalArgumentException("Not a page");
        }
        Window window = ((Page)parent).createWindow(this.getName(), this.content.getContentType(), this.content.getURI());
        window.setDeclaredProperty("theme.region", this.region);
        window.setDeclaredProperty("theme.order", "" + this.order);
        if (this.initialWindowState != null) {
            window.setDeclaredProperty("portal.windowInitialState", "" + this.initialWindowState);
        }
        if (this.initialMode != null) {
            window.setDeclaredProperty("portal.windowInitialMode", "" + this.initialMode);
        }
        return window;
    }

    public static WindowMetaData buildPortletWindowMetaData(ContentProviderRegistry contentProviderRegistry, Element windowElt) throws Exception {
        String contentURI;
        ContentType contentType;
        WindowMetaData windowMD = new WindowMetaData();
        String windowName = XMLTools.asString((Element)XMLTools.getUniqueChild((Element)windowElt, (String)"window-name", (boolean)true));
        windowMD.setName(windowName);
        String region = XMLTools.asString((Element)XMLTools.getUniqueChild((Element)windowElt, (String)"region", (boolean)true));
        windowMD.setRegion(region);
        Element element = XMLTools.getUniqueChild((Element)windowElt, (String)"initial-window-state", (boolean)false);
        if (element != null) {
            String initialWindowState = XMLTools.asString((Element)element);
            if (initialWindowState.toLowerCase().equals(WindowState.MAXIMIZED.toString()) || initialWindowState.toLowerCase().equals(WindowState.MINIMIZED.toString()) || initialWindowState.toLowerCase().equals(WindowState.NORMAL.toString())) {
                windowMD.setInitialWindowState(initialWindowState);
            } else {
                logger.error((Object)("initial-window-state for '" + windowName + "' must be one of 'MAXIMIZED', 'MINIMIZED' or 'NORMAL'"));
            }
        }
        if ((element = XMLTools.getUniqueChild((Element)windowElt, (String)"initial-mode", (boolean)false)) != null) {
            String initialMode = XMLTools.asString((Element)element);
            windowMD.setInitialMode(initialMode);
        }
        int height = Integer.parseInt(XMLTools.asString((Element)XMLTools.getUniqueChild((Element)windowElt, (String)"height", (boolean)true)));
        windowMD.setOrder(height);
        Element instanceRefElt = XMLTools.getUniqueChild((Element)windowElt, (String)"instance-ref", (boolean)false);
        if (instanceRefElt != null) {
            contentType = ContentType.PORTLET;
            contentURI = XMLTools.asString((Element)instanceRefElt);
        } else {
            Element contentElt = XMLTools.getUniqueChild((Element)windowElt, (String)"content", (boolean)true);
            Element contentTypeElt = XMLTools.getUniqueChild((Element)contentElt, (String)"content-type", (boolean)true);
            Element contentURIElt = XMLTools.getUniqueChild((Element)contentElt, (String)"content-uri", (boolean)true);
            contentType = ContentType.create(XMLTools.asString((Element)contentTypeElt));
            contentURI = XMLTools.asString((Element)contentURIElt);
        }
        ContentMetaData contentMD = new ContentMetaData();
        contentMD.setContentType(contentType);
        contentMD.setURI(contentURI);
        windowMD.setContent(contentMD);
        return windowMD;
    }

    public String toString() {
        return "Window[" + this.getName() + "]";
    }
}

