/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.jsr168;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jboss.portal.portlet.container.PortletContainer;
import org.jboss.portal.portlet.impl.info.ContainerUserInfo;
import org.jboss.portal.portlet.impl.jsr168.PortletApplicationImpl;
import org.jboss.portal.portlet.spi.SecurityContext;
import org.jboss.portal.portlet.spi.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRequestAttributes {
    protected static final Object REMOVED_ATTRIBUTE = new Object();
    private final SecurityContext securityContext;
    private final PortletContainer container;
    private final UserContext userContext;
    private final HttpServletRequestWrapper wreq;
    private Map<String, Object> attributes;

    public PortletRequestAttributes(SecurityContext securityContext, PortletContainer container, UserContext userContext, HttpServletRequestWrapper wreq) {
        if (securityContext == null) {
            throw new IllegalArgumentException("No null portlet request allowed");
        }
        if (container == null) {
            throw new IllegalArgumentException("No null container allowed");
        }
        if (userContext == null) {
            throw new IllegalArgumentException("No null user context allowed");
        }
        if (wreq == null) {
            throw new IllegalArgumentException("No null wrapped request allowed");
        }
        this.securityContext = securityContext;
        this.container = container;
        this.userContext = userContext;
        this.wreq = wreq;
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if ("javax.portlet.userinfo".equals(name)) {
            if (!this.securityContext.isAuthenticated()) {
                return null;
            }
            Map<String, String> infos = this.userContext.getInformations();
            if (infos != null) {
                PortletApplicationImpl portletApp = (PortletApplicationImpl)this.container.getPortletApplication();
                ContainerUserInfo userInfo = portletApp.getInfo().getUser();
                infos = new HashMap<String, String>(infos);
                infos.keySet().retainAll(userInfo.getSupportedUserAttributes());
                infos = Collections.unmodifiableMap(infos);
            } else {
                infos = Collections.emptyMap();
            }
            return infos;
        }
        Object value = null;
        if (this.attributes != null) {
            value = this.attributes.get(name);
        }
        if (value == null && this.wreq != null) {
            value = this.wreq.getAttribute(name);
        } else if (value == REMOVED_ATTRIBUTE) {
            value = null;
        }
        return value;
    }

    public Iterator<String> getAttributeNames() {
        HashSet<String> names = new HashSet<String>();
        Enumeration e = this.wreq.getAttributeNames();
        while (e.hasMoreElements()) {
            names.add((String)e.nextElement());
        }
        if (this.attributes != null) {
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (value == REMOVED_ATTRIBUTE) {
                    names.remove(name);
                    continue;
                }
                names.add(name);
            }
        }
        if (this.securityContext.isAuthenticated()) {
            names.add("javax.portlet.userinfo");
        }
        return names.iterator();
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (!"javax.portlet.userinfo".equals(name)) {
            if (value == null) {
                value = REMOVED_ATTRIBUTE;
            }
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(name, value);
        }
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.setAttribute(name, null);
    }

    public void setAttributeMap(Map<String, Object> map) {
        for (Map.Entry<String, Object> attribute : map.entrySet()) {
            this.setAttribute(attribute.getKey(), attribute.getValue());
        }
    }

    public Map<String, Object> getAttributeMap() {
        Map<String, Object> map = Collections.emptyMap();
        if (this.attributes != null) {
            for (Map.Entry<String, Object> attribute : this.attributes.entrySet()) {
                if (attribute.getValue() == REMOVED_ATTRIBUTE) continue;
                if (map.size() == 0) {
                    map = new HashMap<String, Object>(this.attributes.size());
                }
                map.put(attribute.getKey(), attribute.getValue());
            }
        }
        return map;
    }
}

