/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity;

import javax.management.Notification;

public class UserActivity {
    public static final int NAVIGATION = 0;
    public static final int EXIT = 1;
    private String id;
    private String sessionId;
    private long timestamp;
    private final int type;
    public static final String GUEST = "guest";

    private UserActivity() {
        this.type = 0;
    }

    public UserActivity(String id, String sessionId, long timestamp, int type) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        this.id = id;
        this.sessionId = sessionId;
        this.timestamp = timestamp;
        this.type = type;
    }

    public UserActivity(Notification notification) {
        if (notification.getMessage() == null) {
            throw new IllegalArgumentException("Id (notification message) cannot be null");
        }
        this.id = notification.getMessage().substring(0, notification.getMessage().indexOf("_"));
        this.sessionId = notification.getMessage().substring(notification.getMessage().indexOf("_"));
        this.timestamp = notification.getTimeStamp();
        this.type = Integer.parseInt(notification.getType());
    }

    public String getId() {
        return this.id;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserActivity that = (UserActivity)o;
        return this.id.equals(that.id) && this.sessionId.equals(that.sessionId);
    }

    public int hashCode() {
        int result = this.id.hashCode() + this.sessionId.hashCode();
        return result;
    }
}

