/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.portlet.state;

import org.jboss.portal.common.value.BooleanValue;
import org.jboss.portal.common.value.FloatValue;
import org.jboss.portal.common.value.IntegerValue;
import org.jboss.portal.common.value.StringValue;
import org.jboss.portal.common.value.Value;
import org.jboss.portal.core.impl.portlet.state.TypedStringArray;

public class ValueManager {
    public static final int TYPE_STRING = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_BOOLEAN = 3;
    public static final int TYPE_FLOAT = 4;

    public static Value toValue(TypedStringArray tsa) {
        switch (tsa.getType()) {
            case 2: {
                return new IntegerValue(tsa.getStrings());
            }
            case 3: {
                return new BooleanValue(tsa.getStrings());
            }
            case 4: {
                return new FloatValue(tsa.getStrings());
            }
        }
        return new StringValue(tsa.getStrings());
    }

    public static TypedStringArray toTypedStringArray(Value value) {
        if (value.isInstanceOf(Integer.class)) {
            return new TypedStringArray(2, value.asStringArray());
        }
        if (value.isInstanceOf(Boolean.class)) {
            return new TypedStringArray(3, value.asStringArray());
        }
        if (value.isInstanceOf(Float.class)) {
            return new TypedStringArray(4, value.asStringArray());
        }
        return new TypedStringArray(1, value.asStringArray());
    }
}

