/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.ui.actions;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jboss.logging.Logger;
import org.jboss.portal.api.node.PortalNode;
import org.jboss.portal.api.node.PortalNodeURL;
import org.jboss.portal.core.identity.services.metadata.CoreIdentityConfigurationException;
import org.jboss.portal.core.identity.services.workflow.RegistrationService;
import org.jboss.portal.core.identity.ui.IdentityUIUser;
import org.jboss.portal.core.identity.ui.common.IdentityUserBean;
import org.jboss.portal.core.identity.ui.common.MetaDataServiceBean;
import org.jboss.portal.server.ServerInvocationContext;
import org.jboss.portlet.JBossActionRequest;
import org.jboss.portlet.JBossActionResponse;

public class CreateUserAction {
    private List roles = new ArrayList();
    private List defaultRoles = null;
    private IdentityUIUser uiUser = new IdentityUIUser();
    private RegistrationService registrationService;
    private IdentityUserBean identityUserBean;
    private MetaDataServiceBean metaDataService;
    private static final Logger log = Logger.getLogger(CreateUserAction.class);

    public IdentityUIUser getUiUser() {
        return this.uiUser;
    }

    public void setUiUser(IdentityUIUser uiUser) {
        this.uiUser = uiUser;
    }

    public List getRoles() {
        return this.roles;
    }

    public void setRoles(List roles) {
        this.roles = roles;
    }

    public void setDefaultRoles(List roles) {
        this.roles = roles;
        this.defaultRoles = roles;
    }

    public IdentityUserBean getIdentityUserBean() {
        return this.identityUserBean;
    }

    public void setIdentityUserBean(IdentityUserBean identityUserBean) {
        this.identityUserBean = identityUserBean;
    }

    public RegistrationService getRegistrationService() {
        return this.registrationService;
    }

    public void setRegistrationService(RegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public MetaDataServiceBean getMetaDataService() {
        return this.metaDataService;
    }

    public void setMetaDataService(MetaDataServiceBean metaDataService) {
        this.metaDataService = metaDataService;
    }

    public String cancelRegistration() {
        this.uiUser = new IdentityUIUser();
        this.roles = this.defaultRoles;
        return "start";
    }

    public void register(ActionEvent ev) {
        String registrationStatus = "failed";
        FacesContext ctx = FacesContext.getCurrentInstance();
        String adminSubscription = ev.getComponent().getId();
        ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", ctx.getViewRoot().getLocale());
        if (this.uiUser.getUsername() != null && this.uiUser.getPassword() != null) {
            try {
                Class registrationDateClass = this.uiUser.getAttribute().getType("registrationdate");
                if (registrationDateClass.equals(Date.class)) {
                    this.uiUser.getAttribute().setValue("registrationdate", new Date());
                } else if (registrationDateClass.equals(String.class)) {
                    this.uiUser.getAttribute().setValue("registrationdate", new Date().toString());
                } else {
                    log.warn((Object)("portal.user.registration-date property is mapped in not supported type: " + registrationDateClass.toString()));
                }
                String wUsername = this.uiUser.getUsername();
                String wPassword = this.uiUser.getPassword();
                List wRoles = this.roles;
                Map<String, Object> wProfileMap = this.identityUserBean.getProfileMap(this.uiUser.getAttribute().getProfileAttributes());
                Locale wLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
                String wURL = this.getPortalURL();
                registrationStatus = adminSubscription != null && adminSubscription.equals("admin") ? this.registrationService.registerUser(wURL, wUsername, wPassword, wProfileMap, wRoles, wLocale, true) : this.registrationService.registerUser(wURL, wUsername, wPassword, wProfileMap, wRoles, wLocale, false);
            }
            catch (CoreIdentityConfigurationException e) {
                registrationStatus = "registration_failed";
                log.error((Object)"", (Throwable)e);
            }
        }
        this.uiUser = new IdentityUIUser();
        if ("registration_pending".equals(registrationStatus) && !adminSubscription.equals("admin")) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(bundle.getString("IDENTITY_REGISTER_PENDING_TITLE")));
        } else if ("registered".equals(registrationStatus) && !adminSubscription.equals("admin")) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(bundle.getString("IDENTITY_REGISTER_SUCCESS_TITLE")));
        } else if (adminSubscription.equals("admin") && !"registration_failed".equals(registrationStatus)) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(bundle.getString("IDENTITY_MANAGEMENT_CREATE_USER_CREATED")));
        } else {
            FacesContext.getCurrentInstance().addMessage("status", new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_VALIDATION_ERROR_REGISTRATION"), bundle.getString("IDENTITY_VALIDATION_ERROR_REGISTRATION")));
        }
    }

    private String getPortalURL() {
        ExternalContext ectx = FacesContext.getCurrentInstance().getExternalContext();
        JBossActionRequest request = (JBossActionRequest)ectx.getRequest();
        JBossActionResponse response = (JBossActionResponse)ectx.getResponse();
        ServerInvocationContext invocationContext = request.getControllerContext().getServerInvocation().getServerContext();
        PortalNode n = request.getPortalNode();
        PortalNodeURL url = response.createRenderURL(n);
        url.setRelative(false);
        String portalURL = url.toString();
        String a = invocationContext.getPortalContextPath();
        int contextPathIndex = portalURL.indexOf(a);
        String cleanPortalURL = portalURL.substring(0, contextPathIndex);
        cleanPortalURL = cleanPortalURL + a;
        return cleanPortalURL;
    }
}

