/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.PojoCacheMBean;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.TimeoutException;

public class JBossCacheWrapper {
    private static final int RETRY = 3;
    private PojoCacheMBean proxy_;

    JBossCacheWrapper(PojoCacheMBean cache) {
        this.proxy_ = cache;
    }

    Object get(Fqn fqn, String id) {
        return this.get(fqn, id, false);
    }

    Object get(Fqn fqn, String id, boolean gravitate) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                Object value = null;
                if (gravitate) {
                    Option option = new Option();
                    option.setForceDataGravitation(true);
                    value = this.proxy_.get(fqn, (Object)id, option);
                } else {
                    value = this.proxy_.get(fqn, (Object)id);
                }
                return value;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("JBossCacheService: exception occurred in cache get ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache get after retry ... ", ex);
    }

    void put(Fqn fqn, String id, Object value) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.proxy_.put(fqn, (Object)id, value);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("JBossCacheService: exception occurred in cache put ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache put after retry ... ", ex);
    }

    void put(Fqn fqn, Map map) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.proxy_.put(fqn, map);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("JBossCacheService: exception occurred in cache put ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache put after retry ... ", ex);
    }

    Object remove(Fqn fqn, String id) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.proxy_.remove(fqn, (Object)id);
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("JBossCacheService: exception occurred in cache remove ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache remove after retry ... ", ex);
    }

    void remove(Fqn fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.proxy_.remove(fqn);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("JBossCacheService: exception occurred in cache remove ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache remove after retry ... ", ex);
    }

    void evict(Fqn fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.proxy_.evict(fqn);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("JBossCacheService: exception occurred in cache evict ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache evict after retry ... ", ex);
    }

    void evictSubtree(Fqn fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                Option option = new Option();
                option.setCacheModeLocal(true);
                this.proxy_.remove(fqn, option);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("JBossCacheService: exception occurred in cache evictSubtree ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache evictSubtree after retry ... ", ex);
    }
}

