/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.service;

import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.identity.event.UserProfileChangedEvent;
import org.jboss.portal.identity.info.ProfileInfo;
import org.jboss.portal.identity.metadata.config.ConfigurationParser;
import org.jboss.portal.identity.metadata.profile.info.ProfileInfoSupport;
import org.jboss.portal.identity.service.IdentityModuleService;

public abstract class UserProfileModuleService
extends IdentityModuleService
implements UserProfileModule {
    private static final Logger log = Logger.getLogger(UserProfileModuleService.class);
    protected ProfileInfo profileInfo;
    private String profileConfigFile;

    protected UserProfileModuleService() {
        super("UserProfile");
    }

    public void start() throws Exception {
        if (this.getProfileConfigFile() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Processing profile configuration for the module....");
            }
            this.profileInfo = new ProfileInfoSupport(ConfigurationParser.parseProfileConfiguration(this.getProfileConfigFile()));
        }
        super.start();
    }

    public void setProfileInfo(ProfileInfo profileInfo) {
        this.profileInfo = profileInfo;
    }

    public String getProfileConfigFile() {
        return this.profileConfigFile;
    }

    public void setProfileConfigFile(String profileConfigFile) {
        this.profileConfigFile = profileConfigFile;
    }

    protected void fireUserProfileChangedEvent(Object userId, String userName, String propertyName, Object newValue) throws IdentityException {
        UserProfileChangedEvent event = new UserProfileChangedEvent(userId, userName, propertyName, newValue);
        this.getIdentityEventBroadcaster().fireEvent(event);
    }
}

