/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.jbc.cacheprovider;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.OptimisticCache;
import org.hibernate.cache.OptimisticCacheSource;
import org.hibernate.cache.StandardQueryCache;
import org.hibernate.cache.UpdateTimestampsCache;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.hibernate.jbc.cacheprovider.CacheProperties;
import org.jboss.hibernate.jbc.cacheprovider.SecondLevelCacheUtil;
import org.jboss.logging.Logger;

public class OptimisticJBCCache
implements OptimisticCache {
    private static final Logger log = Logger.getLogger(OptimisticJBCCache.class);
    private static final String ITEM = "item";
    private TreeCache cache;
    private final String regionName;
    private final Fqn regionFqn;
    private OptimisticCacheSource source;
    private boolean queryCacheLocalWritesOnly;
    private boolean localPutsOnly;
    private final CacheProperties cacheProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptimisticJBCCache(TreeCache cache, String regionName, CacheProperties cacheProperties) throws CacheException {
        this.cache = cache;
        this.regionName = regionName;
        this.cacheProperties = cacheProperties;
        this.regionFqn = Fqn.fromString((String)SecondLevelCacheUtil.createRegionFqn(regionName, this.cacheProperties.getCacheRegionPrefix()));
        this.queryCacheLocalWritesOnly = this.cacheProperties.isQueryCacheLocalWritesOnly() && regionName.contains(StandardQueryCache.class.getName());
        boolean bl = this.localPutsOnly = this.cacheProperties.isLocalPutsOnly() && !regionName.contains(UpdateTimestampsCache.class.getName());
        if (cache.getUseRegionBasedMarshalling()) {
            boolean fetchState = cache.getFetchInMemoryState();
            try {
                if (this.queryCacheLocalWritesOnly) {
                    cache.setFetchInMemoryState(false);
                }
                this.activateCacheRegion(this.regionFqn.toString());
            }
            finally {
                if (this.queryCacheLocalWritesOnly) {
                    cache.setFetchInMemoryState(fetchState);
                }
            }
        } else {
            log.debug((Object)"TreeCache is not configured for region based marshalling");
        }
    }

    public void setSource(OptimisticCacheSource source) {
        this.source = source;
    }

    public void writeInsert(Object key, Object value, Object currentVersion) {
        this.writeUpdate(key, value, currentVersion, null);
    }

    public void writeUpdate(Object key, Object value, Object currentVersion, Object previousVersion) {
        try {
            Option option = new Option();
            DataVersion dv = this.source != null && this.source.isVersioned() ? new DataVersionAdapter(currentVersion, previousVersion, this.source.getVersionComparator(), this.source.toString()) : NonLockingDataVersion.INSTANCE;
            option.setDataVersion(dv);
            option.setCacheModeLocal(this.queryCacheLocalWritesOnly);
            this.cache.put(new Fqn(this.regionFqn, key), (Object)ITEM, value, option);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void writeLoad(Object key, Object value, Object currentVersion) {
        try {
            Option option = new Option();
            option.setFailSilently(true);
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            option.setCacheModeLocal(this.queryCacheLocalWritesOnly || this.localPutsOnly);
            this.cache.remove(new Fqn(this.regionFqn, key), (Object)"ITEM", option);
            option = new Option();
            option.setFailSilently(true);
            DataVersion dv = this.source != null && this.source.isVersioned() ? new DataVersionAdapter(currentVersion, currentVersion, this.source.getVersionComparator(), this.source.toString()) : NonLockingDataVersion.INSTANCE;
            option.setDataVersion(dv);
            option.setCacheModeLocal(this.queryCacheLocalWritesOnly || this.localPutsOnly);
            this.cache.put(new Fqn(this.regionFqn, key), (Object)ITEM, value, option);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public Object get(Object key) throws CacheException {
        try {
            Option option = new Option();
            option.setFailSilently(true);
            return this.cache.get(new Fqn(this.regionFqn, key), (Object)ITEM, option);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public Object read(Object key) throws CacheException {
        try {
            return this.cache.get(new Fqn(this.regionFqn, key), (Object)ITEM);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void update(Object key, Object value) throws CacheException {
        try {
            Option option = new Option();
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            option.setCacheModeLocal(this.queryCacheLocalWritesOnly);
            this.cache.put(new Fqn(this.regionFqn, key), (Object)ITEM, value, option);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void put(Object key, Object value) throws CacheException {
        try {
            log.trace((Object)("performing put() into region [" + this.regionName + "]"));
            Option option = new Option();
            option.setFailSilently(true);
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            option.setCacheModeLocal(this.queryCacheLocalWritesOnly || this.localPutsOnly);
            this.cache.put(new Fqn(this.regionFqn, key), (Object)ITEM, value, option);
        }
        catch (TimeoutException te) {
            log.debug((Object)"ignoring write lock acquisition failure");
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void remove(Object key) throws CacheException {
        try {
            if (this.cache.get(new Fqn(this.regionFqn, key), (Object)ITEM) != null) {
                Option option = new Option();
                option.setDataVersion(NonLockingDataVersion.INSTANCE);
                option.setCacheModeLocal(this.queryCacheLocalWritesOnly);
                this.cache.remove(new Fqn(this.regionFqn, key), option);
            } else {
                log.trace((Object)"skipping remove() call as the underlying node did not seem to exist");
            }
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void clear() throws CacheException {
        try {
            Option option = new Option();
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            option.setCacheModeLocal(this.queryCacheLocalWritesOnly);
            this.cache.remove(this.regionFqn, option);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void destroy() throws CacheException {
        try {
            Option option = new Option();
            option.setCacheModeLocal(true);
            option.setFailSilently(true);
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            this.cache.remove(this.regionFqn, option);
            if (this.cache.getUseRegionBasedMarshalling() && !SecondLevelCacheUtil.isSharedClassLoaderRegion(this.regionName)) {
                this.inactivateCacheRegion();
            }
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void lock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public void unlock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        try {
            Set children = this.cache.getChildrenNames(this.regionFqn);
            return children == null ? 0L : (long)children.size();
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map toMap() {
        try {
            HashMap result = new HashMap();
            Set childrenNames = this.cache.getChildrenNames(this.regionFqn);
            if (childrenNames != null) {
                for (Object key : childrenNames) {
                    result.put(key, this.cache.get(new Fqn(this.regionFqn, key), (Object)ITEM));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public String toString() {
        return "OptimisticJBCCache(" + this.regionName + ')';
    }

    private void activateCacheRegion(String regionName) throws CacheException {
        String fqnString = this.regionFqn.toString();
        if (this.cache.getMarshaller().isInactive(fqnString)) {
            try {
                if (!SecondLevelCacheUtil.isSharedClassLoaderRegion(regionName)) {
                    this.cache.registerClassLoader(fqnString, Thread.currentThread().getContextClassLoader());
                }
                this.cache.activateRegion(fqnString);
            }
            catch (Exception e) {
                throw SecondLevelCacheUtil.convertToHibernateException(e);
            }
        } else {
            log.debug((Object)("activateCacheRegion(): Region " + fqnString + " is already active"));
        }
    }

    private void inactivateCacheRegion() throws CacheException {
        String fqnString = this.regionFqn.toString();
        if (!this.cache.getMarshaller().isInactive(fqnString)) {
            try {
                this.cache.inactivateRegion(fqnString);
                this.cache.unregisterClassLoader(fqnString);
            }
            catch (Exception e) {
                throw SecondLevelCacheUtil.convertToHibernateException(e);
            }
        } else {
            log.debug((Object)("inactivateCacheRegion(): Region " + fqnString + " is already inactive"));
        }
    }

    public static class CircumventChecksDataVersion
    implements DataVersion {
        private static final long serialVersionUID = 7996980646166032369L;
        public static final DataVersion INSTANCE = new CircumventChecksDataVersion();

        public boolean newerThan(DataVersion dataVersion) {
            throw new CacheException("optimistic locking checks should never happen on CircumventChecksDataVersion");
        }
    }

    public static class NonLockingDataVersion
    implements DataVersion {
        private static final long serialVersionUID = 7050722490368630553L;
        public static final DataVersion INSTANCE = new NonLockingDataVersion();

        public boolean newerThan(DataVersion dataVersion) {
            log.trace((Object)"non locking lock check...");
            return false;
        }
    }

    public static class DataVersionAdapter
    implements DataVersion {
        private static final long serialVersionUID = 5564692336076405571L;
        private final Object currentVersion;
        private final Object previousVersion;
        private final Comparator versionComparator;
        private final String sourceIdentifer;

        public DataVersionAdapter(Object currentVersion, Object previousVersion, Comparator versionComparator, String sourceIdentifer) {
            this.currentVersion = currentVersion;
            this.previousVersion = previousVersion;
            this.versionComparator = versionComparator;
            this.sourceIdentifer = sourceIdentifer;
            log.trace((Object)("created " + this));
        }

        public boolean newerThan(DataVersion dataVersion) {
            log.trace((Object)("checking [" + this + "] against [" + dataVersion + "]"));
            if (dataVersion instanceof CircumventChecksDataVersion) {
                log.trace((Object)"skipping lock checks...");
                return false;
            }
            if (dataVersion instanceof NonLockingDataVersion) {
                log.trace((Object)"skipping lock checks...");
                return false;
            }
            DataVersionAdapter other = (DataVersionAdapter)dataVersion;
            if (other.previousVersion == null) {
                log.warn((Object)"Unexpected optimistic lock check on inserting data");
                if (this == dataVersion) {
                    log.trace((Object)"skipping lock checks due to same DV instance");
                    return false;
                }
            }
            if (this.currentVersion == null) {
                return other.previousVersion != null;
            }
            return this.versionComparator.compare(this.currentVersion, other.previousVersion) >= 1;
        }

        public String toString() {
            return super.toString() + " [current=" + this.currentVersion + ", previous=" + this.previousVersion + ", src=" + this.sourceIdentifer + "]";
        }
    }
}

