/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.Hashtable;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.JDBCDataSourceMBean;
import org.jboss.management.j2ee.JDBCResource;
import org.jboss.management.j2ee.StateManagement;

public class JDBCDataSource
extends J2EEManagedObject
implements JDBCDataSourceMBean {
    private static Logger log = Logger.getLogger(JDBCDataSource.class);
    private StateManagement mState;
    private ObjectName mService;
    private ObjectName mJdbcDriver;

    public static ObjectName create(MBeanServer pServer, String pName, ObjectName pService) {
        ObjectName lServer = null;
        try {
            lServer = pServer.queryNames(new ObjectName(J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "J2EEServer" + "," + "*"), null).iterator().next();
        }
        catch (Exception e) {
            log.error((Object)("Could not locate JSR-77 Server: " + pName), (Throwable)e);
            return null;
        }
        ObjectName lJDBC = null;
        try {
            Set<ObjectName> lNames = pServer.queryNames(new ObjectName(J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "JDBCResource" + "," + "*"), null);
            lJDBC = lNames.isEmpty() ? JDBCResource.create(pServer, "JDBC") : lNames.iterator().next();
        }
        catch (Exception e) {
            log.error((Object)"Could not create JSR-77 JDBC Manager", (Throwable)e);
            return null;
        }
        try {
            pName = pName.replace(':', '~');
            return pServer.createMBean("org.jboss.management.j2ee.JDBCDataSource", null, new Object[]{pName, lJDBC, pService}, new String[]{String.class.getName(), ObjectName.class.getName(), ObjectName.class.getName()}).getObjectName();
        }
        catch (Exception e) {
            log.error((Object)("Could not create JSR-77 JDBC DataSource: " + pName), (Throwable)e);
            return null;
        }
    }

    public static void destroy(MBeanServer pServer, String pName) {
        try {
            J2EEManagedObject.removeObject(pServer, J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "JDBCDataSource" + "," + "name=" + pName + "," + "*");
            JDBCResource.destroy(pServer, "JDBC");
        }
        catch (Exception e) {
            log.error((Object)("Could not destroy JSR-77 JDBC DataSource: " + pName), (Throwable)e);
        }
    }

    public JDBCDataSource(String pName, ObjectName pServer, ObjectName pService) throws MalformedObjectNameException, InvalidParentException {
        super("JDBCDataSource", pName, pServer);
        this.mService = pService;
        this.mState = new StateManagement(this);
    }

    public String[] getEventTypes() {
        return StateManagement.stateTypes;
    }

    public String getEventType(int pIndex) {
        if (pIndex >= 0 && pIndex < StateManagement.stateTypes.length) {
            return StateManagement.stateTypes[pIndex];
        }
        return null;
    }

    public long getStartTime() {
        return this.mState.getStartTime();
    }

    public int getState() {
        return this.mState.getState();
    }

    public String getStateString() {
        return this.mState.getStateString();
    }

    public void mejbStart() {
        try {
            this.getServer().invoke(this.mService, "start", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getLog().error((Object)"start failed", (Throwable)e);
        }
    }

    public void mejbStartRecursive() {
        this.mejbStart();
    }

    public void mejbStop() {
        try {
            this.getServer().invoke(this.mService, "stop", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Stop of JDBCDataSource failed", (Throwable)e);
        }
    }

    public void postCreation() {
        try {
            this.getServer().addNotificationListener(this.mService, this.mState, null, null);
        }
        catch (JMException jme) {
            this.getLog().debug((Object)"Could not add listener at target service", (Throwable)jme);
        }
        this.sendNotification("j2ee.object.created", "JDBC DataSource Resource deleted");
    }

    public void preDestruction() {
        this.sendNotification("j2ee.object.deleted", "JDBC DataSource Resource deleted");
        try {
            this.getServer().removeNotificationListener(this.mService, this.mState);
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    public ObjectName getJdbcDriver() {
        return this.mJdbcDriver;
    }

    public String toString() {
        return "JDBCDatasource { " + super.toString() + " } [ " + " ]";
    }

    protected Hashtable getParentKeys(ObjectName pParent) {
        Hashtable<String, String> lReturn = new Hashtable<String, String>();
        Hashtable<String, String> lProperties = pParent.getKeyPropertyList();
        lReturn.put("JDBCResource", lProperties.get("name"));
        lReturn.put("J2EEServer", lProperties.get("J2EEServer"));
        return lReturn;
    }
}

