/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.jsf.integration.injection;

import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.catalina.util.DefaultAnnotationProcessor;
import org.jboss.logging.Logger;

public class JBossInjectionProvider
implements InjectionProvider {
    private static final Logger LOG = Logger.getLogger(JBossInjectionProvider.class);
    private static final String NAMING_DISABLED = "Injection of naming resources into JSF managed beans disabled.";
    private Context namingContext;
    private DefaultAnnotationProcessor annotationProcessor = null;

    public JBossInjectionProvider() {
        try {
            this.namingContext = new InitialContext();
            this.annotationProcessor = new DefaultAnnotationProcessor(this.namingContext);
        }
        catch (Exception e) {
            LOG.warn((Object)NAMING_DISABLED, (Throwable)e);
        }
    }

    protected JBossInjectionProvider(Context namingContext) {
        if (namingContext == null) {
            LOG.warn((Object)NAMING_DISABLED);
        }
        this.namingContext = namingContext;
        this.annotationProcessor = new DefaultAnnotationProcessor(this.namingContext);
    }

    public void invokePreDestroy(Object managedBean) throws InjectionProviderException {
        try {
            this.annotationProcessor.preDestroy(managedBean);
        }
        catch (Exception e) {
            LOG.error((Object)"PreDestroy failed on managed bean.", (Throwable)e);
        }
    }

    public void invokePostConstruct(Object managedBean) throws InjectionProviderException {
        try {
            this.annotationProcessor.postConstruct(managedBean);
        }
        catch (Exception e) {
            LOG.error((Object)"PostConstruct failed on managed bean.", (Throwable)e);
        }
    }

    public void inject(Object managedBean) throws InjectionProviderException {
        if (this.namingContext != null) {
            try {
                this.annotationProcessor.processAnnotations(managedBean);
            }
            catch (Exception e) {
                LOG.error((Object)"Injection failed on managed bean.", (Throwable)e);
            }
        }
    }
}

