/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.controller.impl;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.io.Serialization;
import org.jboss.portal.common.io.SerializationFilter;
import org.jboss.portal.common.text.CharBuffer;
import org.jboss.portal.common.text.CharEncoder;
import org.jboss.portal.common.text.FastURLEncoder;
import org.jboss.portal.common.util.Base64;
import org.jboss.portal.portlet.ContainerURL;
import org.jboss.portal.portlet.URLFormat;
import org.jboss.portal.portlet.controller.impl.ControllerRequestParameterMapFactory;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletURLRenderer {
    final Serialization<PortletPageNavigationalState> serialization;
    final HttpServletRequest clientReq;
    final HttpServletResponse clientResp;
    final PortletPageNavigationalState pageNS;

    public PortletURLRenderer(PortletPageNavigationalState pageNS, HttpServletRequest clientReq, HttpServletResponse clientResp, Serialization<PortletPageNavigationalState> serialization) {
        this.pageNS = pageNS;
        this.clientReq = clientReq;
        this.clientResp = clientResp;
        this.serialization = serialization;
    }

    private String renderURL(Map<String, String> parameters, URLFormat format) {
        CharBuffer buffer = new CharBuffer();
        buffer.append((CharSequence)this.clientReq.getScheme());
        buffer.append((CharSequence)"://");
        buffer.append((CharSequence)this.clientReq.getServerName());
        buffer.append(':');
        buffer.append((CharSequence)Integer.toString(this.clientReq.getServerPort()));
        buffer.append((CharSequence)this.clientReq.getContextPath());
        buffer.append((CharSequence)this.clientReq.getServletPath());
        if (this.clientReq.getPathInfo() != null) {
            buffer.append((CharSequence)this.clientReq.getPathInfo());
        }
        String parameterSeparator = format.getWantEscapeXML() == Boolean.TRUE ? "&amp;" : "&";
        boolean first = true;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            buffer.append((CharSequence)(first ? "?" : parameterSeparator));
            buffer.append(name, (CharEncoder)FastURLEncoder.getUTF8Instance());
            buffer.append('=');
            buffer.append(value, (CharEncoder)FastURLEncoder.getUTF8Instance());
            first = false;
        }
        String url = buffer.asString();
        return this.clientResp.encodeURL(url);
    }

    public String renderURL(URLFormat format) {
        String pageNavigationalState = null;
        if (this.pageNS != null) {
            byte[] bytes = IOTools.serialize(this.serialization, (SerializationFilter)SerializationFilter.COMPRESSOR, (Object)this.pageNS);
            pageNavigationalState = Base64.encodeBytes((byte[])bytes, (boolean)true);
        }
        Map<Object, Object> parameters = pageNavigationalState != null ? Collections.singletonMap("pagenavigationalstate", pageNavigationalState) : Collections.emptyMap();
        return this.renderURL(parameters, format);
    }

    public String renderURL(String windowId, ContainerURL containerURL, URLFormat format) {
        ControllerRequestParameterMapFactory factory = new ControllerRequestParameterMapFactory(this.serialization);
        Map<String, String> parameters = factory.encode(this.pageNS, windowId, containerURL);
        parameters.put("type", "portlet");
        return this.renderURL(parameters, format);
    }
}

