/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.security;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.Collection;
import java.util.Set;
import org.jboss.portal.portlet.security.PortletPermission;
import org.jboss.portal.portlet.security.PortletSecurityService;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.PortalPermissionCollection;
import org.jboss.portal.security.PortalSecurityException;
import org.jboss.portal.security.RoleSecurityBinding;
import org.jboss.portal.security.SecurityConstants;
import org.jboss.portal.security.impl.JBossAuthorizationDomainRegistry;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManagerFactory;
import org.jboss.portal.security.spi.provider.AuthorizationDomain;
import org.jboss.portal.security.spi.provider.DomainConfigurator;
import org.jboss.portal.security.spi.provider.PermissionFactory;
import org.jboss.portal.security.spi.provider.PermissionRepository;
import org.jboss.portal.security.spi.provider.SecurityConfigurationException;

public class JBossPortletSecurityService
implements PortletSecurityService,
AuthorizationDomain,
DomainConfigurator,
PermissionRepository,
PermissionFactory {
    protected ConcurrentReaderHashMap securityConstraintsMap;
    protected PortalAuthorizationManagerFactory portalAuthorizationManagerFactory;
    protected JBossAuthorizationDomainRegistry authorizationDomainRegistry;

    public AuthorizationDomain getAuthorizationDomain() {
        return this;
    }

    public String getType() {
        return "portlet";
    }

    public DomainConfigurator getConfigurator() {
        return this;
    }

    public PermissionRepository getPermissionRepository() {
        return this;
    }

    public PermissionFactory getPermissionFactory() {
        return this;
    }

    public Set getSecurityBindings(String uri) {
        return (Set)this.securityConstraintsMap.get((Object)uri);
    }

    public void setSecurityBindings(String uri, Set securityBindings) throws SecurityConfigurationException {
        this.securityConstraintsMap.put((Object)uri, (Object)securityBindings);
    }

    public void removeSecurityBindings(String uri) throws SecurityConfigurationException {
        this.securityConstraintsMap.remove((Object)uri);
    }

    public PortalPermission getPermission(String roleName, String uri) throws PortalSecurityException {
        Set set = this.getSecurityBindings(uri);
        if (set != null && !set.isEmpty()) {
            for (RoleSecurityBinding sc : set) {
                String constraintRoleName = sc.getRoleName();
                if (!constraintRoleName.equals(roleName) && !SecurityConstants.UNCHECKED_ROLE_NAME.equals(constraintRoleName)) continue;
                return this.createPermission(uri, sc.getActions());
            }
        }
        return null;
    }

    public PortalPermission createPermissionContainer(PortalPermissionCollection collection) throws PortalSecurityException {
        return new PortletPermission(collection);
    }

    public PortalPermission createPermission(String uri, String action) throws PortalSecurityException {
        return new PortletPermission(uri, action);
    }

    public PortalPermission createPermission(String uri, Collection actions) throws PortalSecurityException {
        return new PortletPermission(uri, actions);
    }

    public void create() throws Exception {
        this.securityConstraintsMap = new ConcurrentReaderHashMap();
    }

    public void start() throws Exception {
        this.authorizationDomainRegistry.addDomain((AuthorizationDomain)this);
    }

    public void stop() throws Exception {
        this.authorizationDomainRegistry.removeDomain((AuthorizationDomain)this);
    }

    public void destroy() {
        this.securityConstraintsMap = null;
    }

    public JBossAuthorizationDomainRegistry getAuthorizationDomainRegistry() {
        return this.authorizationDomainRegistry;
    }

    public void setAuthorizationDomainRegistry(JBossAuthorizationDomainRegistry authorizationDomainRegistry) {
        this.authorizationDomainRegistry = authorizationDomainRegistry;
    }

    public PortalAuthorizationManagerFactory getPortalAuthorizationManagerFactory() {
        return this.portalAuthorizationManagerFactory;
    }

    public void setPortalAuthorizationManagerFactory(PortalAuthorizationManagerFactory portalAuthorizationManagerFactory) {
        this.portalAuthorizationManagerFactory = portalAuthorizationManagerFactory;
    }
}

