/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.filebrowser.portlet.controller;

import fr.gouv.education.foad.filebrowser.portlet.model.FileBrowserBulkDownloadContent;
import fr.gouv.education.foad.filebrowser.portlet.model.FileBrowserForm;
import fr.gouv.education.foad.filebrowser.portlet.model.FileBrowserSort;
import fr.gouv.education.foad.filebrowser.portlet.model.FileBrowserView;
import fr.gouv.education.foad.filebrowser.portlet.service.FileBrowserService;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.osivia.portal.api.context.PortalControllerContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class FileBrowserController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private FileBrowserService service;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @RequestParam(name="view", required=false) String viewId) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        FileBrowserView view = this.service.getView(portalControllerContext, viewId);
        request.setAttribute("view", (Object)view.getId());
        this.service.updateMenubar(portalControllerContext);
        return "view";
    }

    @ActionMapping(value="change-view")
    public void changeView(ActionRequest request, ActionResponse response, @RequestParam(value="view") String viewId) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        FileBrowserView view = FileBrowserView.fromId((String)viewId);
        this.service.saveView(portalControllerContext, view);
        response.setRenderParameter("view", view.getId());
    }

    @ActionMapping(value="sort")
    public void sort(ActionRequest request, ActionResponse response, @RequestParam(value="sort") String sort, @RequestParam(value="alt") String alt, @RequestParam(name="view", required=false) String viewId, @ModelAttribute(value="form") FileBrowserForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.sortItems(portalControllerContext, form, FileBrowserSort.fromId((String)sort), BooleanUtils.toBoolean((String)alt));
        FileBrowserView view = this.service.getView(portalControllerContext, viewId);
        response.setRenderParameter("view", view.getId());
    }

    @ActionMapping(value="duplicate")
    public void duplicate(ActionRequest request, ActionResponse response, @RequestParam(value="path") String path, @RequestParam(name="view", required=false) String viewId) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.duplicate(portalControllerContext, path);
        FileBrowserView view = this.service.getView(portalControllerContext, viewId);
        response.setRenderParameter("view", view.getId());
    }

    @ActionMapping(value="delete")
    public void delete(ActionRequest request, ActionResponse response, @RequestParam(value="identifiers") String identifiers, @RequestParam(name="view", required=false) String viewId) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.delete(portalControllerContext, Arrays.asList(StringUtils.split((String)identifiers, (String)",")));
        FileBrowserView view = this.service.getView(portalControllerContext, viewId);
        response.setRenderParameter("view", view.getId());
    }

    @ActionMapping(value="drop")
    public void drop(ActionRequest request, ActionResponse response, @RequestParam(value="sourceIds") String sourceIds, @RequestParam(value="targetId") String targetId, @RequestParam(name="view", required=false) String viewId) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.drop(portalControllerContext, Arrays.asList(StringUtils.split((String)sourceIds, (String)",")), targetId);
        FileBrowserView view = this.service.getView(portalControllerContext, viewId);
        response.setRenderParameter("view", view.getId());
    }

    @ActionMapping(value="upload")
    public void upload(ActionRequest request, ActionResponse response, @RequestParam(name="view", required=false) String viewId, @ModelAttribute(value="form") FileBrowserForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.upload(portalControllerContext, form);
        FileBrowserView view = this.service.getView(portalControllerContext, viewId);
        response.setRenderParameter("view", view.getId());
    }

    @ResourceMapping(value="toolbar")
    public void getToolbar(ResourceRequest request, ResourceResponse response, @RequestParam(name="indexes", required=false) String indexes, @RequestParam(name="view", required=false) String viewId) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        Element toolbar = this.service.getToolbar(portalControllerContext, Arrays.asList(StringUtils.split((String)StringUtils.trimToEmpty((String)indexes), (String)",")), viewId);
        response.setContentType("text/html");
        HTMLWriter htmlWriter = new HTMLWriter(response.getPortletOutputStream());
        htmlWriter.write(toolbar);
        htmlWriter.close();
    }

    @ResourceMapping(value="bulk-download")
    public void getBulkDownload(ResourceRequest request, ResourceResponse response, @RequestParam(value="paths") String paths) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        FileBrowserBulkDownloadContent content = this.service.getBulkDownload(portalControllerContext, Arrays.asList(StringUtils.split((String)paths, (String)",")));
        response.setContentType(content.getType());
        response.setProperty("Content-disposition", content.getDisposition());
        response.setCharacterEncoding("UTF-8");
        response.getCacheControl().setExpirationTime(0);
        response.setBufferSize(4096);
        FileInputStream inputSteam = new FileInputStream(content.getFile());
        OutputStream outputStream = response.getPortletOutputStream();
        IOUtils.copy((InputStream)inputSteam, (OutputStream)outputStream);
        outputStream.close();
    }

    @ModelAttribute(value="form")
    public FileBrowserForm getForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }

    @ModelAttribute(value="views")
    public List<FileBrowserView> getViews(PortletRequest request, PortletResponse response) throws PortletException {
        return Arrays.asList(FileBrowserView.values());
    }

    @ModelAttribute(value="sorts")
    public List<FileBrowserSort> getSorts(PortletRequest request, PortletResponse response) throws PortletException {
        return Arrays.asList(FileBrowserSort.values());
    }
}

