/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.filebrowser.portlet.model.comparator;

import fr.gouv.education.foad.filebrowser.portlet.model.FileBrowserItem;
import fr.gouv.education.foad.filebrowser.portlet.model.FileBrowserSort;
import fr.gouv.education.foad.filebrowser.portlet.model.FileBrowserSortCriteria;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class FileBrowserItemComparator
implements Comparator<FileBrowserItem> {
    private final FileBrowserSortCriteria criteria;

    public FileBrowserItemComparator(FileBrowserSortCriteria criteria) {
        this.criteria = criteria;
    }

    @Override
    public int compare(FileBrowserItem item1, FileBrowserItem item2) {
        int result;
        boolean folderish2;
        boolean folderish1 = item1.isFolderish();
        boolean folderishComparison = BooleanUtils.xor((boolean[])new boolean[]{folderish1, folderish2 = item2.isFolderish()});
        if (folderishComparison) {
            result = folderish1 ? -1 : 1;
        } else if (FileBrowserSort.LAST_MODIFICATION.equals((Object)this.criteria.getSort())) {
            Date date1 = item1.getLastModification();
            Date date2 = item2.getLastModification();
            result = date1 == null ? -1 : (date2 == null ? 1 : date1.compareTo(date2));
        } else if (FileBrowserSort.FILE_SIZE.equals((Object)this.criteria.getSort())) {
            Long size1 = item1.getSize();
            Long size2 = item2.getSize();
            result = size1 == null ? -1 : (size2 == null ? 1 : size1.compareTo(size2));
        } else {
            String title1 = StringUtils.trimToEmpty((String)item1.getTitle());
            String title2 = StringUtils.trimToEmpty((String)item2.getTitle());
            result = title1.compareToIgnoreCase(title2);
        }
        if (this.criteria.isAlt() && !folderishComparison) {
            result = -result;
        }
        return result;
    }
}

