/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.filebrowser.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.List;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.StreamBlob;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@Scope(value="prototype")
public class ImportFilesCommand
implements INuxeoCommand {
    private final String path;
    private final List<MultipartFile> upload;

    public ImportFilesCommand(String path, List<MultipartFile> upload) {
        this.path = path;
        this.upload = upload;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        Blobs blobs = new Blobs(this.upload.size());
        for (MultipartFile multipartFile : this.upload) {
            StreamBlob blob = new StreamBlob(multipartFile.getInputStream(), multipartFile.getOriginalFilename(), multipartFile.getContentType());
            blobs.add((Object)blob);
        }
        OperationRequest operationRequest = nuxeoSession.newRequest("FileManager.Import");
        operationRequest.setInput((OperationInput)blobs);
        operationRequest.setHeader("nx_es_sync", String.valueOf(true));
        operationRequest.setContextProperty("currentDocument", (Object)this.path);
        operationRequest.set("overwite", (Object)true);
        return operationRequest.execute();
    }

    public String getId() {
        return null;
    }
}

