/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.room.controller;

import fr.gouv.education.foad.room.controller.AnalyzeRoomsCommand;
import fr.gouv.education.foad.room.controller.RoomMigForm;
import fr.gouv.education.foad.room.controller.RoomMigration;
import fr.gouv.education.foad.room.controller.TransformRoomCommand;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.IOException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.workspace.portlet.repository.command.GetPermissionsCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"form"})
public class RoomController
extends CMSPortlet
implements PortletConfigAware,
PortletContextAware {
    private Log log = LogFactory.getLog((String)"org.osivia.directory.v2");
    private PortletConfig portletConfig;
    private PortletContext portletContext;
    @Autowired
    protected IBundleFactory bundleFactory;
    @Autowired
    protected INotificationsService notificationsService;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="urlFactoryForRoomMig")
    private IPortalUrlFactory portalUrlFactory;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @PreDestroy
    public void preDestroy() {
        super.destroy();
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) {
        return "view";
    }

    @ExceptionHandler
    public String exceptionHandler(PortletRequest request, PortletResponse response) throws PortletException {
        return "error";
    }

    @ActionMapping(value="migration")
    public void migration(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") RoomMigForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty("osivia.cms.uri");
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        boolean runExec = BooleanUtils.toBoolean((String)request.getParameter("exec"));
        if (!runExec) {
            this.log.info((Object)"===========");
            this.log.info((Object)("D\u00e9but analyse, " + path));
            nuxeoController.setAsynchronousCommand(false);
            List lrm = (List)nuxeoController.executeNuxeoCommand((INuxeoCommand)new AnalyzeRoomsCommand(path, form));
            form.setLrm(lrm);
            this.examineAcl(nuxeoController, form);
            form.setAnalyseDone(Boolean.valueOf(true));
            this.log.info((Object)"Fin analyse,");
            this.log.info((Object)"===========");
        } else {
            nuxeoController.setAsynchronousCommand(true);
            nuxeoController.executeNuxeoCommand((INuxeoCommand)new TransformRoomCommand(form.getLrm()));
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("MIGRATION_IN_PROGRESS"), NotificationsType.INFO);
            String cmsUrl = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, path, null, null, "refreshPageAndNavigation", null, null, null, null);
            response.sendRedirect(cmsUrl);
        }
    }

    private void examineAcl(NuxeoController nuxeoController, RoomMigForm form) {
        this.log.info((Object)"= Phase 2 - recherche des droits \u00e0 extraire.");
        Integer nbRoomsInError = form.getNbRoomsInError();
        for (RoomMigration rm : form.getLrm()) {
            INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetPermissionsCommand.class, new Object[]{rm.getRoom()});
            JSONObject result = (JSONObject)nuxeoController.executeNuxeoCommand(command);
            JSONArray localArray = result.getJSONArray("local");
            if (localArray.size() <= 0) continue;
            this.log.warn((Object)(" La salle " + rm.getRoom().getTitle() + " poss\u00e8de des droits sp\u00e9cifiques qui seront migr\u00e9s.."));
            rm.setAcls(localArray);
        }
        form.setNbRoomsInError(nbRoomsInError);
    }

    @ModelAttribute(value="form")
    public RoomMigForm getChgValidDateForm() {
        return new RoomMigForm();
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }
}

