/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.osivia.services.workspace.portlet.model.InvitationState;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class GetInvitationsCommand
implements INuxeoCommand {
    private final String workspaceId;
    private final String modelId;
    private final InvitationState invitationState;
    private final Set<String> identifiers;

    public GetInvitationsCommand(String workspaceId) {
        this(workspaceId, null, false);
    }

    public GetInvitationsCommand(String workspaceId, boolean request) {
        this(workspaceId, null, request);
    }

    public GetInvitationsCommand(String workspaceId, InvitationState invitationState) {
        this(workspaceId, invitationState, false);
    }

    public GetInvitationsCommand(String workspaceId, InvitationState invitationState, boolean request) {
        this.workspaceId = workspaceId;
        this.modelId = request ? "invitation-request" : "invitation";
        this.invitationState = invitationState;
        this.identifiers = null;
    }

    public GetInvitationsCommand(String workspaceId, InvitationState invitationState, Set<String> identifiers) {
        this.workspaceId = workspaceId;
        this.modelId = null;
        this.invitationState = invitationState;
        this.identifiers = identifiers;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:primaryType = 'ProcedureInstance' ");
        if (this.workspaceId != null) {
            clause.append("AND pi:globalVariablesValues.").append("workspaceId").append(" = '").append(this.workspaceId).append("' ");
        }
        if (this.modelId != null) {
            clause.append("AND pi:procedureModelWebId = '").append("procedure_").append(this.modelId).append("' ");
        }
        if (this.invitationState != null) {
            clause.append("AND pi:globalVariablesValues.").append("invitationState").append(" = '").append(this.invitationState.toString()).append("' ");
        }
        if (this.identifiers != null) {
            clause.append("AND pi:globalVariablesValues.").append("uid").append(" IN (");
            boolean first = true;
            for (String member : this.identifiers) {
                if (first) {
                    first = false;
                } else {
                    clause.append(", ");
                }
                clause.append("'").append(member).append("'");
            }
            clause.append(") ORDER BY dc:created DESC");
        }
        String filteredClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"dublincore, procedureInstance");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredClause));
        return request.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("/");
        if (this.workspaceId != null) {
            builder.append(this.workspaceId);
        }
        builder.append("/");
        if (this.modelId != null) {
            builder.append(this.modelId);
        }
        builder.append("/");
        if (this.invitationState != null) {
            builder.append(this.invitationState.toString());
        }
        builder.append("/");
        if (this.identifiers != null) {
            builder.append(StringUtils.join((Collection)this.identifiers, (String)","));
        }
        return builder.toString();
    }
}

